/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.verbs.ScatterGatherElement;
import java.util.LinkedList;

public class SendWorkRequest {
    public static final int IBV_SEND_FENCE = 1;
    public static final int IBV_SEND_SIGNALED = 2;
    public static final int IBV_SEND_SOLICITED = 4;
    public static final int IBV_SEND_INLINE = 8;
    protected long workRequestId;
    protected LinkedList<ScatterGatherElement> sgeList;
    protected int sgeCount;
    protected Opcode opCode;
    protected int sendFlags;
    protected int immediateData;
    protected Rdma rdma;
    protected Atomic atomic;
    protected Ud ud;

    public SendWorkRequest() {
        this.rdma = new Rdma();
        this.atomic = new Atomic();
        this.ud = new Ud();
        this.sgeList = new LinkedList();
    }

    protected SendWorkRequest(Rdma rdma, Atomic atomic, Ud ud, LinkedList<ScatterGatherElement> linkedList) {
        this.rdma = rdma;
        this.atomic = atomic;
        this.ud = ud;
        this.sgeList = linkedList;
    }

    public long getWorkRequestId() {
        return this.workRequestId;
    }

    public void setWorkRequestId(long l) {
        this.workRequestId = l;
    }

    public LinkedList<ScatterGatherElement> getSgeList() {
        return this.sgeList;
    }

    public ScatterGatherElement getSge(int n) {
        return this.sgeList.get(n);
    }

    public void setSgeList(LinkedList<ScatterGatherElement> linkedList) {
        this.sgeList.clear();
        this.sgeList.addAll(linkedList);
        this.sgeCount = linkedList.size();
    }

    public int getSgeCount() {
        return this.sgeCount;
    }

    protected void setSgeCount(int n) {
        this.sgeCount = n;
    }

    public Opcode getOpcode() {
        return this.opCode;
    }

    public void setOpcode(Opcode opcode) {
        this.opCode = opcode;
    }

    public int getSendFlags() {
        return this.sendFlags;
    }

    public void setSendFlags(int n) {
        this.sendFlags = n;
    }

    protected int getImmediateData() {
        return this.immediateData;
    }

    protected void setImmediateData(int n) {
        this.immediateData = n;
    }

    public Rdma getRdma() {
        return this.rdma;
    }

    protected Atomic getAtomic() {
        return this.atomic;
    }

    protected Ud getUd() {
        return this.ud;
    }

    protected static class Ud {
        protected int addressHandle;
        protected int remoteQpn;
        protected int remoteQkey;
        protected int reserved;

        public int getAddressHandle() {
            return this.addressHandle;
        }

        public void setAddressHandle(int n) {
            this.addressHandle = n;
        }

        public int getRemoteQueuePairNum() {
            return this.remoteQpn;
        }

        public void setRemoteQueuePairNum(int n) {
            this.remoteQpn = n;
        }

        public int getRemoteQkey() {
            return this.remoteQkey;
        }

        public void setRemoteQkey(int n) {
            this.remoteQkey = n;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int n) {
            this.reserved = n;
        }

        public String getClassName() {
            return Ud.class.getCanonicalName();
        }
    }

    protected static class Atomic {
        protected long remoteAddress;
        protected long compareAddress;
        protected long swap;
        protected int remoteKey;
        protected int reserved;

        public long getRemoteAddress() {
            return this.remoteAddress;
        }

        public void setRemoteAddress(long l) {
            this.remoteAddress = l;
        }

        public long getCompareAddress() {
            return this.compareAddress;
        }

        public void setCompareAddress(long l) {
            this.compareAddress = l;
        }

        public long getSwap() {
            return this.swap;
        }

        public void setSwap(long l) {
            this.swap = l;
        }

        public int getRemoteKey() {
            return this.remoteKey;
        }

        public void setRemoteKey(int n) {
            this.remoteKey = n;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int n) {
            this.reserved = n;
        }

        public String getClassName() {
            return Atomic.class.getCanonicalName();
        }
    }

    public static class Rdma {
        protected long remoteAddress;
        protected int remoteKey;
        protected int reserved;

        public Rdma() {
            this.reserved = 0;
        }

        public Rdma(long l, int n) {
            this.remoteAddress = l;
            this.remoteKey = n;
            this.reserved = 0;
        }

        public long getRemoteAddress() {
            return this.remoteAddress;
        }

        public void setRemoteAddress(long l) {
            this.remoteAddress = l;
        }

        public int getRemoteKey() {
            return this.remoteKey;
        }

        public void setRemoteKey(int n) {
            this.remoteKey = n;
        }

        protected int getReserved() {
            return this.reserved;
        }

        protected void setReserved(int n) {
            this.reserved = n;
        }
    }

    public static enum Opcode {
        IBV_WR_RDMA_WRITE(0),
        IBV_WR_SEND(2),
        IBV_WR_RDMA_READ(4);

        private int value;

        private Opcode(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

