********************************************************************
* <copyright                                                       *
* notice="lm-source-program"                                       *
* pids=""                                                          *
* years="1994,2000"                                                *
* crc="1152400473" >                                               *
* Licensed Materials - Property of IBM                             *
*                                                                  *
*                                                                  *
*                                                                  *
* (C) Copyright IBM Corp. 1994, 2000 All Rights Reserved.          *
*                                                                  *
* US Government Users Restricted Rights - Use, duplication or      *
* disclosure restricted by GSA ADP Schedule Contract with          *
* IBM Corp.                                                        *
* </copyright>                                                     *
* Change Activity:                                                 *
* 23/08/99 - IX75938.1 - Changed Backout count attribute to        *
* HARDENBO                                                         *
********************************************************************
********************************************************************
*       SYSTEM.ADMIN.MQMLIST.userid                                *
*       This queue stores information about the queue managers     *
*       being managed, and the control options.                    *
********************************************************************
    DEFINE QLOCAL('SYSTEM.ADMIN.QMLIST.OS2') REPLACE  +

*   Queue description
            DESCR('Queue Managers managed by the admin app')   +
*   Put operations allowed
      PUT(ENABLED)       +
*   Default priority
      DEFPRTY(5)         +
*   Default non-persistent
      DEFPSIST(YES)       +
*   Get operations allowed
      GET(ENABLED)       +

*   Maximum queue depth
      MAXDEPTH(5000)   +
*   Maximum message length
      MAXMSGL(256)   +
*   shareable
      SHARE            +
*   Input open option
      DEFSOPT(SHARED)      +
*   Delivery by priority
      MSGDLVSQ(FIFO) +
*   Backout not hardened
      HARDENBO         +
*   Normal queue usage
      USAGE(NORMAL)      +

*   Trigger control off
      NOTRIGGER          +
*   otherwise trigger on first message
      TRIGTYPE(NONE)    +

**** next five defaults apply if trigger is made active
*   Trigger on first message
      TRIGDPTH(1)        +
*   Trigger on any priority
      TRIGMPRI(0)        +
*   Trigger data
      TRIGDATA(' ')      +
*   Process name if trigger
      PROCESS(' ')       +
*   Initiation queue name
      INITQ(' ')         +

**** other attributes can be tested, but MQM takes no action
*   Retention time (hours)
      RETINTVL(999999999)        +
*   Backout threshold
      BOTHRESH(5)        +
*   Backout requeue name
      BOQNAME(' ')

********************************************************************
*       SYSTEM.ADMIN.REPLYQ.userid                                 *
*       This queue is the reply to queue for requests sent to a    *
*       command server queue and the administrator datastore.      *
********************************************************************
    DEFINE QLOCAL('SYSTEM.ADMIN.REPLYQ.OS2') REPLACE  +

*   Queue description
      DESCR('admin app reply Q')   +
*   Put operations allowed
      PUT(ENABLED)       +
*   Default priority
      DEFPRTY(5)         +
*   Default non-persistent
      DEFPSIST(YES)       +
*   Get operations allowed
      GET(ENABLED)       +

*   Maximum queue depth
      MAXDEPTH(5000)   +
*   Maximum message length
      MAXMSGL(65000)   +
*   shareable
      SHARE            +
*   Input open option
      DEFSOPT(SHARED)      +
*   Delivery by priority
      MSGDLVSQ(FIFO) +
*   Backout not hardened
      HARDENBO         +
*   Normal queue usage
      USAGE(NORMAL)      +

*   Trigger control off
      NOTRIGGER          +
*   otherwise trigger on first message
      TRIGTYPE(NONE)    +

**** next five defaults apply if trigger is made active
*   Trigger on first message
      TRIGDPTH(1)        +
*   Trigger on any priority
      TRIGMPRI(0)        +
*   Trigger data
      TRIGDATA(' ')      +
*   Process name if trigger
      PROCESS(' ')       +
*   Initiation queue name
      INITQ(' ')         +

**** other attributes can be tested, but MQM takes no action
*   Retention time (hours)
      RETINTVL(999999999)        +
*   Backout threshold
      BOTHRESH(5)        +
*   Backout requeue name
      BOQNAME(' ')

********************************************************************
*       SYSTEM.ADMIN.RESPQ.userid                                  *
*       This queue is used to stored copies of the remote commands *
*       sent to a command server queue and the responses received  *
*       in reply.                                                  *
********************************************************************
    DEFINE QLOCAL('SYSTEM.ADMIN.RESPQ.OS2') REPLACE  +

*   Queue description
      DESCR('admin app response Q')   +
*   Put operations allowed
      PUT(ENABLED)       +
*   Default priority
      DEFPRTY(5)         +
*   Default non-persistent
      DEFPSIST(YES)       +
*   Get operations allowed
      GET(ENABLED)       +
*   Maximum queue depth
      MAXDEPTH(5000)   +
*   Maximum message length
      MAXMSGL(65000)   +
*   shareable
      SHARE            +
*   Input open option
      DEFSOPT(SHARED)      +
*   Delivery by priority
      MSGDLVSQ(FIFO) +
*   Backout not hardened
      HARDENBO         +
*   Normal queue usage
      USAGE(NORMAL)      +
*   Trigger control off
      NOTRIGGER          +
*   otherwise trigger on first message
      TRIGTYPE(NONE)    +
**** next five defaults apply if trigger is made active
*   Trigger on first message
      TRIGDPTH(1)        +
*   Trigger on any priority
      TRIGMPRI(0)        +
*   Trigger data
      TRIGDATA(' ')      +
*   Process name if trigger
      PROCESS(' ')       +
*   Initiation queue name
      INITQ(' ')         +
**** other attributes can be tested, but MQM takes no action
*   Retention time (hours)
      RETINTVL(999999999)        +
*   Backout threshold
      BOTHRESH(5)        +
*   Backout requeue name
      BOQNAME(' ')

********************************************************************
*       SYSTEM.ADMIN.EXCEPTION.QUEUE                               *
*       This queue is used for diagnostic purposes. Invalid        *
*       messages and other diagnostic information is written to    *
*       this queue.                                                *
********************************************************************
    DEFINE QLOCAL('SYSTEM.ADMIN.EXCEPTION.QUEUE') REPLACE  +

*   Queue description
      DESCR('admin app exception Q')   +
*   Put operations allowed
      PUT(ENABLED)       +
*   Default priority
      DEFPRTY(5)         +
*   Default non-persistent
      DEFPSIST(YES)       +
*   Get operations allowed
      GET(ENABLED)       +
*   Maximum queue depth
      MAXDEPTH(5000)   +
*   Maximum message length
      MAXMSGL(65000)   +
*   shareable
      SHARE            +
*   Input open option
      DEFSOPT(SHARED)      +
*   Delivery by priority
      MSGDLVSQ(FIFO) +
*   Backout not hardened
      HARDENBO         +
*   Normal queue usage
      USAGE(NORMAL)      +
*   Trigger control off
      NOTRIGGER          +
*   otherwise trigger on first message
      TRIGTYPE(NONE)    +
**** next five defaults apply if trigger is made active
*   Trigger on first message
      TRIGDPTH(1)        +
*   Trigger on any priority
      TRIGMPRI(0)        +
*   Trigger data
      TRIGDATA(' ')      +
*   Process name if trigger
      PROCESS(' ')       +
*   Initiation queue name
      INITQ(' ')         +
**** other attributes can be tested, but MQM takes no action
*   Retention time (hours)
      RETINTVL(999999999)        +
*   Backout threshold
      BOTHRESH(5)        +
*   Backout requeue name
      BOQNAME(' ')

********************************************************************
*       SYSTEM.ADMIN.AMQMDATA.QUEUE                                *
*       This queue is the data store server queue. The data store  *
*       keeps information on objects on queue managers being       *
*       administrated by administrators working on this machine.   *
********************************************************************
    DEFINE QLOCAL('SYSTEM.ADMIN.DATASTORE.QUEUE') REPLACE  +

*   Queue description
      DESCR('admin app data store Q')   +
*   Put operations allowed
      PUT(ENABLED)       +
*   Default priority
      DEFPRTY(5)         +
*   Default non-persistent
      DEFPSIST(YES)       +
*   Get operations allowed
      GET(ENABLED)       +
*   Maximum queue depth
      MAXDEPTH(5000)   +
*   Maximum message length
      MAXMSGL(65000)   +
*   shareable
      SHARE            +
*   Input open option
      DEFSOPT(SHARED)      +
*   Delivery by priority
      MSGDLVSQ(PRIORITY) +
*   Backout not hardened
      HARDENBO         +
*   Normal queue usage
      USAGE(NORMAL)      +
*   Trigger control off
      NOTRIGGER          +
*   otherwise trigger on first message
      TRIGTYPE(NONE)    +
**** next five defaults apply if trigger is made active
*   Trigger on first message
      TRIGDPTH(1)        +
*   Trigger on any priority
      TRIGMPRI(0)        +
*   Trigger data
      TRIGDATA(' ')      +
*   Process name if trigger
      PROCESS(' ')       +
*   Initiation queue name
      INITQ(' ')         +
**** other attributes can be tested, but MQM takes no action
*   Retention time (hours)
      RETINTVL(999999999)        +
*   Backout threshold
      BOTHRESH(5)        +
*   Backout requeue name
      BOQNAME(' ')

