********************************************************************/
*                                                                  */
* Program name: AMQSCIC0                                           */
*                                                                  */
* Description: Sample MQSC source defining MQM sample queues       */
*              Can be processed, with changes as needed, after     */
*              starting the MQM                                    */
* <copyright                                                       */
* notice="lm-source-program"                                       */
* pids="5639-B43,"                                                 */
* years="1994,2001"                                                */
* crc="845588784" >                                                */
* Licensed Materials - Property of IBM                             */
*                                                                  */
* 5639-B43,                                                        */
*                                                                  */
* (C) Copyright IBM Corp. 1994, 2001 All Rights Reserved.          */
*                                                                  */
* US Government Users Restricted Rights - Use, duplication or      */
* disclosure restricted by GSA ADP Schedule Contract with          */
* IBM Corp.                                                        */
* </copyright>                                                     */
*                                                                  */
********************************************************************/
* Function:                                                        */
*                                                                  */
*                                                                  */
*   AMQSCIC0 is a sample MQSC file to create or reset sample       */
*   MQI resources of the Message Queue Manager (MQM).              */
*   It includes the following.                                     */
*                                                                  */
*      -- definition of objects used by the CICS sample programs   */
*                                                                  */
*   This file, or a similar one, can be processed when the MQM     */
*   is started - it creates the objects if missing, or resets      */
*   their attributes to the prescribed values.                     */
*                                                                  */
********************************************************************/
*                                                                  */
*   AMQSCIC0 is sample data for the MQSC utility                   */
*                                                                  */
********************************************************************/

********************************************************************/
*   Define a dummy channel for a dummy remote queue manager        */
********************************************************************/
DEFINE CHANNEL('SYSTEM.SAMPLE.DUMMY') CHLTYPE(SDR) +
       TRPTYPE(TCP) CONNAME('DUMMYQM') +
       XMITQ('SYSTEM.SAMPLE.CICS.WORKQUEUE') +
       REPLACE DESCR('dummy channel for AMQSCIC0')

********************************************************************/
*   Define the work queue for the CICS transaction                 */
********************************************************************/
DEFINE QLOCAL ('SYSTEM.SAMPLE.CICS.WORKQUEUE') +
       LIKE(SYSTEM.DEFAULT.LOCAL.QUEUE) +
       REPLACE SHARE USAGE(XMITQ) +
       DESCR('Input Queue for AMQSCIC0')

********************************************************************/
*   Define the dead letter queue for the CICS transaction          */
********************************************************************/
DEFINE QLOCAL ('SYSTEM.SAMPLE.CICS.DLQ') +
       LIKE(SYSTEM.DEFAULT.LOCAL.QUEUE) +
       REPLACE SHARE USAGE(NORMAL) +
       DESCR('Dead Letter Queue for AMQSCIC0')

********************************************************************/
*   Define three output queues for the transaction                 */
********************************************************************/
DEFINE QLOCAL ('SYSTEM.SAMPLE.CICS.OUTQUEUE.1') +
       LIKE(SYSTEM.DEFAULT.LOCAL.QUEUE) +
       DESCR('TestQ1 for AMQSCIC0') SHARE REPLACE

DEFINE QLOCAL ('SYSTEM.SAMPLE.CICS.OUTQUEUE.2') +
       LIKE(SYSTEM.DEFAULT.LOCAL.QUEUE) +
       DESCR('TestQ2 for AMQSCIC0') SHARE REPLACE

DEFINE QLOCAL ('SYSTEM.SAMPLE.CICS.OUTQUEUE.3') +
       LIKE(SYSTEM.DEFAULT.LOCAL.QUEUE) +
       DESCR('TestQ3 for AMQSCIC0') SHARE REPLACE

********************************************************************/
*   Define three input queues for the transaction                  */
*   Putting messages to these queues stacks up the work queue and  */
*   the messages will be distributed to the target output queues   */
********************************************************************/
DEFINE QREMOTE ('SYSTEM.SAMPLE.CICS.INQUEUE.1') +
       LIKE(SYSTEM.DEFAULT.REMOTE.QUEUE) +
       DESCR('Input Queue for AMQSCIC0 Target TestQ1') +
       XMITQ('SYSTEM.SAMPLE.CICS.WORKQUEUE') +
       REPLACE RNAME('SYSTEM.SAMPLE.CICS.OUTQUEUE.1') +
       RQMNAME('SYSTEM.SAMPLE.CICS.DUMMYQM')

DEFINE QREMOTE ('SYSTEM.SAMPLE.CICS.INQUEUE.2') +
       LIKE(SYSTEM.DEFAULT.REMOTE.QUEUE) +
       DESCR('Input Queue for AMQSCIC0 Target TestQ2') +
       XMITQ('SYSTEM.SAMPLE.CICS.WORKQUEUE') +
       REPLACE RNAME('SYSTEM.SAMPLE.CICS.OUTQUEUE.2') +
       RQMNAME('SYSTEM.SAMPLE.CICS.DUMMYQM')

DEFINE QREMOTE ('SYSTEM.SAMPLE.CICS.INQUEUE.3') +
       LIKE(SYSTEM.DEFAULT.REMOTE.QUEUE) +
       DESCR('Input Queue for AMQSCIC0 Target TestQ3') +
       XMITQ('SYSTEM.SAMPLE.CICS.WORKQUEUE') +
       REPLACE RNAME('SYSTEM.SAMPLE.CICS.OUTQUEUE.3') +
       RQMNAME('SYSTEM.SAMPLE.CICS.DUMMYQM')

