%{
/*********************************************************************/
/*                                                                   */
/* Module Name: AMQODQ0PA.L                                          */
/*                                                                   */
/* Description: RUNMQDLQ Parser: LEX                                 */
/*   <copyright                                                       */
/*   notice="lm-source-program"                                       */
/*   pids="5724-H72,"                                                 */
/*   years="1994,2012"                                                */
/*   crc="2850894229" >                                               */
/*   Licensed Materials - Property of IBM                             */
/*                                                                    */
/*   5724-H72,                                                        */
/*                                                                    */
/*   (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.          */
/*                                                                    */
/*   US Government Users Restricted Rights - Use, duplication or      */
/*   disclosure restricted by GSA ADP Schedule Contract with          */
/*   IBM Corp.                                                        */
/*   </copyright>                                                     */
/*                                                                   */
/*********************************************************************/
/* Following text will be included in the Service Reference Manual.  */
/* Ensure that the content is correct and up-to-date.                */
/* All updates should be made in mixed case.                         */
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/* This file contains the source for LEX for the parser for          */
/* RUNMQDLQ which generates the file amqodqlp.c (often called        */
/* lexyy.c)                                                          */
/*                                                                   */
/* End of text to be included in SRM                                 */
/*********************************************************************/

/*********************************************************************/
/*                                                                   */
/* Module Name: AMQODQ0P.C                                           */
/*                                                                   */
/* Description: RUNMQDLQ parser: LEX                                 */
/*                                                                   */
/* Statement:     Licensed Materials - Property of IBM               */
/*                                                                   */
/*                5765-115 5621-390 (C) Copyright IBM Corp. 1994     */
/*                                                                   */
/*                U.S. Government Users Restricted Rights - use,     */
/*                duplication or disclosure restricted by GSA ADP    */
/*                Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING   */
/*   This file was generated by running the LEX program              */
/*                    against the source file                        */
/*                                                                   */
/*   AMQODQ0PA.L                                                     */
/*                                                                   */
/*   Updates should be made to the above source file and NOT to      */
/*   this file.                                                      */
/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING   */
/*                                                                   */
/*********************************************************************/
#include <errno.h>
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>               /* for toupper() prototype         */
#include <cmqc.h>
#include <string.h>
#include <amqodqha.h>
#include <amqodqma.h>

#ifdef AMQ_AS400
#define isatty(t) 1
#endif

/*------------------------------------------------------------------*/
/*  As all versions of Lex do not support yylineno we have to       */
/*  manage a line count ourselves. The line count is referenced in  */
/*  both the lex and the yacc and so we make it global.             */
/*------------------------------------------------------------------*/
int odqLineNo=1;

/*------------------------------------------------------------------*/
/*  I N T E R N A L    F U N C T I O N    P R O T O T Y P E S       */
/*------------------------------------------------------------------*/
static odqResp odqStrDup( /*OUT*/
	                    char ** target,
	                  /*IN*/
	                    const char * source
	                );
static odqResp odqQStrDup( /*OUT*/
	                     char ** target,
	                   /*IN*/
	                     const char * source
	                 );
static odqResp odqAtoi( /*OUT*/
	                  int * target,
	                /*IN*/
	                  const char * source
	              );
static odqResp odqSymbtoi( /*OUT*/
	                     int * target,
	                   /*IN*/
	                     const char * source
	                 );
int yywrap (void);

%}

string          ([a-zA-Z0-9_./%]+)
iqname          ({string})
fqname          ({string}|(&{d}{e}{s}{t}{q})|(&{r}{e}{p}{l}{y}{q}))
qmname          ({string})
fqmname         ({string}|(" "*)|(&{d}{e}{s}{t}{q}{m})|(&{r}{e}{p}{l}{y}{q}{m}))
qstring         "'"{string}"'"
qiqname         "'"({iqname}|(" ")*)"'"
qfqname         "'"{fqname}"'"
qqmname         "'"({qmname}|(" ")*)"'"
qfqmname        "'"{fqmname}"'"
wstring         [a-zA-Z0-9_./%*?]+
qwstring        \'([^\']+|(\'\'))*\'
number          [0-9]+
a [aA]
b [bB]
c [cC]
d [dD]
e [eE]
f [fF]
g [gG]
h [hH]
i [iI]
j [jJ]
k [kK]
l [lL]
m [mM]
n [nN]
o [oO]
p [pP]
q [qQ]
r [rR]
s [sS]
t [tT]
u [uU]
v [vV]
w [wW]
x [xX]
y [yY]
z [zZ]

%s QMNAMES QNAMES FWDQMS FWDQS WSTRINGS INTEGERS ACTIONS BOOL WAITS PUTAUTS

%e 8000
%n 3000
%o 15000
%k 2000
%p 36000
%a 18000

%%
%{
/*--------------------------------------------------------------------*/
/* Comment lines are identified by an * in column 1.                  */
/* Comment lines can appear in the middle of some other expression and*/
/* are simply stripped out.                                           */
/* We rely upon the pattern .*\n(\*.*) being longer then the          */
/* pattern controlling trailing +'s and -'s to prevent these          */
/* characters from being meaningful on comment lines.                 */
/* We rely upon the pattern ^\*.*\n being as long as the              */
/* pattern controlling trailing +'s and -'s to prevent these          */
/* characters from being meaningful onthe first line in the file      */
/* We rely on the pattern ^\*.*\n\*.*\n being as long as any other    */
/* pattern so that the special meaning of the ^ is not lost when lines*/
/* are joined/removed etc                                             */
/*--------------------------------------------------------------------*/
%}
^\*.*\n                           odqLineNo ++;    /* *,text,NL       */
^\*.*\n\*.*\n                     odqLineNo += 2;  /* *,text,NL,*,text,NL */
.*\n(\*.*)                        {                /* text,NL,*,text */
	                            int i ;
	                            char c;
	                            /*--------------------------------*/
	                            /* read forwards for the end      */
	                            /* of line/file.                  */
	                            /*--------------------------------*/
	                            for( c=input();
	                                 c!=ASCII_NEWLINE &&
	                                 c!=0 ;
	                                 c=input());
	                            /*--------------------------------*/
	                            /* scan the text for the start    */
	                            /* of the comment.                */
	                            /*--------------------------------*/
	                            for( i = 0;
	                                 yytext[i] != ASCII_NEWLINE ||
	                                 yytext[i+1] != ASCII_STAR ;
	                                 i ++);
	                            /*--------------------------------*/
	                            /* Put back the text before       */
	                            /* the start of the comment.      */
	                            /*--------------------------------*/
	                            for( ;
	                                 i >= 0;
	                                 i -- )
	                                 unput(yytext[i]) ;

	                            odqLineNo ++;
	                          }
%{
/*--------------------------------------------------------------------*/
/* The following pattern is intended to strip out null lines.         */
/* The yacc grammar specification is also written to ignore null lines*/
/* because the interaction with the commenting input/unput can cause  */
/* the ^ indicating start of line to fail to match.                   */
/*--------------------------------------------------------------------*/
%}
^[ \r\t]*\n                         odqLineNo ++;     /* space|tabs,NL  */
%{
/*--------------------------------------------------------------------*/
/* The syntax for runmqdlq is based upon the syntax of runmqsc in     */
/* which the '+' and '-' characters cannot be used with a '*' in      */
/* the first character of the new line.                               */
/*--------------------------------------------------------------------*/
%}
%{
/*--------------------------------------------------------------------*/
/* If a line ends with a '+' then it is continued in the first non    */
/* blank character of the following line.                             */
/*--------------------------------------------------------------------*/
%}
.*\+[ \r\t]*\n[ \r\t]*              {   /* text,+,WS,text,NL,WS,text    */
	                            int i ;
	                            /*--------------------------------*/
	                            /* Scan forwards for the newline. */
	                            /*--------------------------------*/
	                            for( i = 0;
	                                 yytext[i] != ASCII_NEWLINE;
	                                 i ++);
	                            /*--------------------------------*/
	                            /* Scan back to the trailing +    */
	                            /*--------------------------------*/
	                            for( i--;
	                                 yytext[i] != ASCII_PLUS;
	                                 i--);
	                            /*--------------------------------*/
	                            /* Put back the text before the   */
	                            /* trailing +                     */
	                            /*--------------------------------*/
	                            for( i-- ;
	                                 i>= 0;
	                                 i-- )
	                                 unput(yytext[i]) ;
	                            odqLineNo ++;
	                          }
%{
/*--------------------------------------------------------------------*/
/* If a line ends with a '-' then it is continued in the first        */
/* character of the following line.                                   */
/*--------------------------------------------------------------------*/
%}
.*\-[ \r\t]*\n                    {  /* text,-,WS,text,NL  */
	                            int i ;
	                            /*--------------------------------*/
	                            /* Scan forwards for the newline. */
	                            /*--------------------------------*/
	                            for( i = 0;
	                                 yytext[i] != ASCII_NEWLINE;
	                                 i++);
	                            /*--------------------------------*/
	                            /* Scan back to the trailing +    */
	                            /*--------------------------------*/
	                            for( i--;
	                                 yytext[i] != ASCII_DASH ;
	                                 i--);
	                            /*--------------------------------*/
	                            /* Put back the text before the   */
	                            /* trailing +                     */
	                            /*--------------------------------*/
	                            for( i-- ;
	                                 i >= 0;
	                                 i-- )
	                                 unput(yytext[i]) ;
	                            odqLineNo ++;
	                          }

<INITIAL>[ \,\r\t]+               ;          /* WS,+ */
<INITIAL>\n                       {          /* NL only */
	                            odqLineNo ++;
	                            return NEWLINE;
	                          }
\(                                return LBRACKET; /* ( only */

<INITIAL>{f}{o}{r}{m}{a}{t}       {         /* INITIAL format */
	                            BEGIN(WSTRINGS);
	                            return FORMAT;
	                          }
<INITIAL>{d}{e}{s}{t}{q}          {         /* INITIAL destq  */
	                            BEGIN(WSTRINGS);
	                            return DESTQ;
	                          }
<INITIAL>{d}{e}{s}{t}{q}{m}       {         /* INITIAL destqm */
	                            BEGIN(WSTRINGS);
	                            return DESTQM;
	                          }
<INITIAL>{r}{e}{p}{l}{y}{q}       {         /* INITIAL replyq  */
	                            BEGIN(WSTRINGS);
	                            return REPLYQ;
	                          }
<INITIAL>{r}{e}{p}{l}{y}{q}{m}    {         /* INITIAL replyqm */
	                            BEGIN(WSTRINGS);
	                            return REPLYQM;
	                          }
<INITIAL>{a}{p}{p}{l}{i}{d}{a}{t} {         /* INITIAL appldat */
	                            BEGIN(WSTRINGS);
	                            return APPLIDAT;
	                          }
<INITIAL>{a}{p}{p}{l}{t}{y}{p}{e} {         /* INITIAL appltype */
	                            BEGIN(INTEGERS);
	                            return APPLTYPE;
	                          }
<INITIAL>{a}{p}{p}{l}{n}{a}{m}{e} {        /* INITIAL applname  */
	                            BEGIN(WSTRINGS);
	                            return APPLNAME;
	                          }
<INITIAL>{u}{s}{e}{r}{i}{d}       {        /* INITIAL userid */
	                            BEGIN(WSTRINGS);
	                            return USERID;
	                          }
<INITIAL>{r}{e}{a}{s}{o}{n}       {        /* INITIAL reason */
	                            BEGIN(INTEGERS);
	                            return REASON;
	                          }
<INITIAL>{m}{s}{g}{t}{y}{p}{e}    {       /* INITIAL msgtype */
	                            BEGIN(INTEGERS);
	                            return MSGTYPE;
	                          }
<INITIAL>{f}{e}{e}{d}{b}{a}{c}{k} {       /* INITIAL feedback */
	                            BEGIN(INTEGERS);
	                            return FEEDBACK;
	                          }
<INITIAL>{p}{e}{r}{s}{i}{s}{t}    {       /* INITIAL persist */
	                            BEGIN(INTEGERS);
	                            return PERSIST;
	                          }
<INITIAL>{a}{c}{t}{i}{o}{n}       {      /* INITIAL action */
	                            BEGIN(ACTIONS);
	                            return ACTION;
	                          }
<INITIAL>{h}{e}{a}{d}{e}{r}       {      /* INITIAL header  */
	                            BEGIN(BOOL);
	                            return HEADER;
	                          }
<INITIAL>{r}{e}{t}{r}{y}          {      /* INITIAL retry  */
	                            BEGIN(INTEGERS);
	                            return RETRY;
	                          }
<INITIAL>{f}{w}{d}{q}             {      /* INITIAL fwdq    */
	                            BEGIN(FWDQS);
	                            return FWDQ;
	                          }
<INITIAL>{f}{w}{d}{q}{m}          {     /* INITIAL fwdqm   */
	                            BEGIN(FWDQMS);
	                            return FWDQM;
	                          }
<INITIAL>{i}{n}{p}{u}{t}{q}{m}    {     /* INITIAL inputqm */
	                            BEGIN(QMNAMES);
	                            return INPUTQM;
	                          }
<INITIAL>{i}{n}{p}{u}{t}{q}       {     /* INITIAL inputq  */
	                            BEGIN(QNAMES);
	                            return INPUTQ;
	                          }
<INITIAL>{r}{e}{t}{r}{y}{i}{n}{t} {     /* INITIAL retryint */
	                            BEGIN(INTEGERS);
	                            return RETRYINT;
	                          }
<INITIAL>{w}{a}{i}{t}             {     /* INITIAL wait    */
	                            BEGIN(WAITS);
	                            return WAIT;
	                          }
<INITIAL>{p}{u}{t}{a}{u}{t}       {    /* INITIAL putaut  */
	                            BEGIN(PUTAUTS);
	                            return PUTAUT;
	                          }

<ACTIONS>[ \,\r\t]+               ;   /* ACTIONS,WS */
<ACTIONS>\)                       {   /* ACTIONS ) */
	                            BEGIN(INITIAL) ;
	                            return RBRACKET;
	                          }
<ACTIONS>{d}{i}{s}{c}{a}{r}{d}    {   /* ACTIONS discard */
	                            yylval.o.i = odqDISCARD ;
	                            return INTEGER;
	                          }
<ACTIONS>{i}{g}{n}{o}{r}{e}       {   /* ACTIONS ignore  */
	                            yylval.o.i = odqIGNORE ;
	                            return INTEGER;
	                          }
<ACTIONS>{r}{e}{t}{r}{y}          {   /* ACTIONS retry   */
	                            yylval.o.i = odqRETRY ;
	                            return INTEGER;
	                          }
<ACTIONS>{f}{w}{d}                {   /* ACTIONS fwd     */
	                            yylval.o.i = odqFORWARD ;
	                            return INTEGER;
	                          }
<ACTIONS>.                        return UNEXPECTED; /* ACTIONS error  */
<BOOL>[ \,\r\t]+                  ;   /* BOOL WS */
<BOOL>\)                          {   /* BOOL )  */
	                            BEGIN(INITIAL) ;
	                            return RBRACKET;
	                          }
<BOOL>{y}{e}{s}                   {   /* BOOL yes */
	                            yylval.o.i = 1 ;
	                            return INTEGER;
	                          }
<BOOL>{n}{o}                      {   /* BOOL no  */
	                            yylval.o.i = 0 ;
	                            return INTEGER;
	                          }
<BOOL>.                           return UNEXPECTED; /* BOOL error  */
<WAITS>[ \,\r\t]+                 ;   /* WAIT WS  */
<WAITS>\)                         {   /* WAIT )   */
	                            BEGIN(INITIAL) ;
	                            return RBRACKET;
	                          }
<WAITS>{y}{e}{s}                  {   /* WAIT yes  */
	                            yylval.o.i = -1 ;
	                            return INTEGER;
	                          }
<WAITS>{n}{o}                     {   /* WAIT no   */
	                            yylval.o.i = 0 ;
	                            return INTEGER;
	                          }
<WAITS>{number}                   {   /* WAIT int  */
	                            odqAtoi( &(yylval.o.i),
	                                     (char *)yytext ) ;
	                            return INTEGER ;
	                          }
<WAITS>.                          return UNEXPECTED; /* WAIT error */
<PUTAUTS>[ \,\r\t]+               ;   /* PUTAUTS WS */
<PUTAUTS>\)                       {   /* PUTAUTS )  */
	                            BEGIN(INITIAL) ;
	                            return RBRACKET;
	                          }
<PUTAUTS>{d}{e}{f}                {   /* PUTAUTS def  */
	                            yylval.o.i = 0 ;
	                            return INTEGER;
	                          }
<PUTAUTS>{c}{t}{x}                {   /* PUTAUTS ctx  */
	                            yylval.o.i = 1 ;
	                            return INTEGER;
	                          }
<PUTAUTS>.                        return UNEXPECTED; /* PUTAUTS error */
<WSTRINGS>[ \,\r\t]+              ;   /* WSTRINGS WS */
<WSTRINGS>{wstring}               {   /* WSTRINGS string */
	                            odqStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return WSTRING ;
	                          }
<WSTRINGS>{qwstring}              {   /* WSTRINGS qstring */
	                            odqQStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return WSTRING ;
	                          }
<WSTRINGS>\)                      {   /* WSTRINGS ) */
	                            BEGIN(INITIAL);
	                            return RBRACKET;
	                          }
<WSTRINGS>.                       return UNEXPECTED; /* WSTRINGS error */
<QMNAMES>[ \,\r\t]+                 ;
<QMNAMES>{qmname}                 {   /* QMNAMES (qmname) */
	                            odqStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<QMNAMES>{qqmname}                {   /* QMNAMES (qqmname) */
	                            odqQStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<QMNAMES>\)                       {   /* QMNAMES ) */
	                            BEGIN(INITIAL);
	                            return RBRACKET;
	                          }
<QMNAMES>.                        return UNEXPECTED; /* QMNAMES error */
<QNAMES>[ \r\t]+                  ;
<QNAMES>{iqname}                  {   /* QNAMES (iqname) */
	                            odqStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<QNAMES>{qiqname}                 {   /* QNAMES (qiqname) */
	                            odqQStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<QNAMES>\)                        {   /* QNAMES ) */
	                            BEGIN(INITIAL);
	                            return RBRACKET;
	                          }
<QNAMES>.                         return UNEXPECTED; /* QNAMES error */
<FWDQS>[ \,\r\t]+                   ; /* FWDQS WS        */
<FWDQS>{fqname}                   {   /* FWDQS (fqname) */
	                            odqStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<FWDQS>{qfqname}                  {   /* FWDQS (qfqname) */
	                            odqQStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<FWDQS>\)                         {   /* FWDQS ) */
	                            BEGIN(INITIAL);
	                            return RBRACKET;
	                          }
<FWDQS>.                          return UNEXPECTED;
<FWDQMS>[ \,\r\t]+                  ;
<FWDQMS>{fqmname}                 {   /* FWDQMS (fqmname) */
	                            odqStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<FWDQMS>{qfqmname}                {   /* FWDQMS (qfqmname) */
	                            odqQStrDup( &(yylval.o.s),
	                                       (char *)yytext ) ;
	                            return STRING ;
	                          }
<FWDQMS>\)                        {   /* FWDQMS ) */
	                            BEGIN(INITIAL);
	                            return RBRACKET;
	                          }
<FWDQMS>.                         return UNEXPECTED; /* FWDQMS error */
<INTEGERS>[ \,\r\t]+                ; /* INTEGERS WS */
<INTEGERS>{number}                {   /* INTEGERS number */
	                            odqAtoi( &(yylval.o.i),
	                                     (char *)yytext ) ;
	                            return INTEGER ;
	                          }
<INTEGERS>{string}                {   /* INTEGERS string */
	                            if( odq_Ok ==
	                                odqSymbtoi( &(yylval.o.i),
	                                (char *)yytext ))
	                            {
	                              return INTEGER ;
	                            }
	                            else
	                            {
	                              return UNEXPECTED ;
	                            }
	                          }
<INTEGERS>\*                      return DEFAULT; /* INTEGERS * */
<INTEGERS>\'\*\'                  return DEFAULT; /* INTEGERS '*' */
<INTEGERS>\)                      {   /* INTEGER ) */
	                            BEGIN(INITIAL);
	                            return RBRACKET;
	                          }
<INTEGERS>.                       return UNEXPECTED; /* INTEGER error */
.                                 return UNEXPECTED; /* unexpected??  */
%%

#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqStrDup

/*********************************************************************/
/*                                                                   */
/* Function: odqStrDup                                               */
/*                                                                   */
/* Description: process an unquoted string                           */
/*                                                                   */
/* Intended Function: Copy an unquoted string to storage with the    */
/*                    correct lifetime for use in a rule.            */
/*                    Fold the string to upper case.                 */
/*                                                                   */
/* Input Parameters: unquoted string                                 */
/*                                                                   */
/* Output Parameters: folded string                                  */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
static odqResp odqStrDup( /*OUT*/
	                    char ** target,
	                  /*IN*/
	                    const char * source
	                 )
{
 const char *psource;
 odqResp rc=odq_Ok ;
 int i;
 int l;
/*--------------------------------------------------------------------*/
/* odqStrDup: Handle an unquoted string.                              */
/*            Take a copy of the source string and convert it to      */
/*            upper case.                                             */
/*--------------------------------------------------------------------*/
 odq_fnc_entry( FUNCTION_ID );

   psource = source ;
   l = strlen( psource ) ;
   rc = odqGetMem(  l+1,
                   "Parameter",
                   (void **)target );
   if (odq_Error > rc )
   {
     for( i = 0 ;
          i < l ;
          i++ )
     {
       (*target)[i] = toupper(psource[i]);
     }
     (*target)[l] = 0 ;
   }
   else
   {
      odqGlobal.odqInputErrorCount ++ ;
   }
   odq_fnc_retcode( FUNCTION_ID, rc ) ;

 return rc ;
}
#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqQStrDup

/*********************************************************************/
/*                                                                   */
/* Function: odqQStrDup                                              */
/*                                                                   */
/* Description: process a quoted string                              */
/*                                                                   */
/* Intended Function: Copy an unquoted string to storage with the    */
/*                    correct lifetime for use in a rule.            */
/*                    Strip off the quotes.                          */
/*                                                                   */
/* Input Parameters: quoted string                                   */
/*                                                                   */
/* Output Parameters: string                                         */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
static odqResp odqQStrDup( /*OUT*/
	                     char ** target,
	                   /*IN*/
	                     const char * source
	                 )
{
 odqResp rc=odq_Ok ;
 int l ;
 const char * psource;
/*--------------------------------------------------------------------*/
/* odqQStrDup: Handle a quoted string.                                */
/*             Take a copy of the source string.                      */
/*--------------------------------------------------------------------*/
 odq_fnc_entry( FUNCTION_ID );

   psource = source;
   l = strlen(psource ) - 2 ;
   rc = odqGetMem(  l+1,
	         "Parameter",
	         (void **)target );
   if (odq_Error > rc )
   {
     memcpy( *target, &(psource[1]), l );
     (*target)[l] = 0 ;
   }
   else
   {
      odqGlobal.odqInputErrorCount ++ ;
   }

 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}
#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqAtoi

/*********************************************************************/
/*                                                                   */
/* Function: odqAtoi                                                 */
/*                                                                   */
/* Description: Convert a numeric string to an integer.              */
/*                                                                   */
/* Intended Function: Convert an numeric string to an integer.       */
/*                                                                   */
/* Input Parameters: numeric string                                  */
/*                                                                   */
/* Output Parameters: integer                                        */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
static odqResp odqAtoi( /*OUT*/
	                  int * target,
	                /*IN*/
	                  const char * source
	              )
{
 odqResp rc=odq_Ok ;
/*--------------------------------------------------------------------*/
/* odqAtoi: Handle a numeric string                                   */
/*          Translate a numeric string to an integer.                 */
/*--------------------------------------------------------------------*/
 odq_fnc_entry( FUNCTION_ID );

 *target = atoi( source) ;

 if ( ( ( (*target == INT_MAX)
        ||(*target == (-INT_MAX - 1)))
      &&(0!=errno) )
    ||( (*target < 0)
      ||(*target > 999999999) ) )
 {
   odqFFDC( /*IN*/
	       FUNCTION_ID,
	       odq_InvalidInteger,
	       odqLineNo,
	       0,
	       source,
	       strlen(source),
	       "InvalidInteger",
	       NULL
	     /*OUT*/
	   ) ;
    rc = odq_InvalidInteger ;
    odqGlobal.odqInputErrorCount ++ ;
 }
 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}

#undef  FUNCTION_ID
#define FUNCTION_ID odqtodqSymbtoi

/*********************************************************************/
/*                                                                   */
/* Function: odqSymbtoi                                              */
/*                                                                   */
/* Description: Convert a symbolic value to an integer.              */
/*                                                                   */
/* Intended Function: Convert a symbolic value to an integer.        */
/*                                                                   */
/* Input Parameters: string                                          */
/*                                                                   */
/* Output Parameters: integer                                        */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
static odqResp odqSymbtoi( /*OUT*/
	                     int * target,
	                   /*IN*/
	                     const char * source
	                 )
{
 odqResp    rc=odq_Ok ;
 char    *  Upper ;
 int        l = strlen(source ) ;
 int        i ;
 int        fFound=0;
 const char *psource;

typedef struct _ODQTABLE
   {
   char        szString[40];
   MQLONG      mqrc;
   } ODQTABLE;

#define     ODQTABLE_LENGTH   564

ODQTABLE       aodqTable[ODQTABLE_LENGTH]=
       { {"MQRC_NONE"                     , MQRC_NONE                      },
         {"MQRC_ACTION_ERROR"             , MQRC_ACTION_ERROR              },
         {"MQRC_ADAPTER_CONN_LOAD_ERROR"  , MQRC_ADAPTER_CONN_LOAD_ERROR   },
         {"MQRC_ADAPTER_CONV_LOAD_ERROR"  , MQRC_ADAPTER_CONV_LOAD_ERROR   },
         {"MQRC_ADAPTER_DEFS_ERROR"       , MQRC_ADAPTER_DEFS_ERROR        },
         {"MQRC_ADAPTER_DEFS_LOAD_ERROR"  , MQRC_ADAPTER_DEFS_LOAD_ERROR   },
         {"MQRC_ADAPTER_DISC_LOAD_ERROR"  , MQRC_ADAPTER_DISC_LOAD_ERROR   },
         {"MQRC_ADAPTER_NOT_AVAILABLE"    , MQRC_ADAPTER_NOT_AVAILABLE     },
         {"MQRC_ADAPTER_SERV_LOAD_ERROR"  , MQRC_ADAPTER_SERV_LOAD_ERROR   },
         {"MQRC_ADAPTER_STORAGE_SHORTAGE" , MQRC_ADAPTER_STORAGE_SHORTAGE  },
         {"MQRC_AIR_ERROR"                , MQRC_AIR_ERROR                 },
         {"MQRC_ALIAS_BASE_Q_TYPE_ERROR"  , MQRC_ALIAS_BASE_Q_TYPE_ERROR   },
         {"MQRC_ALIAS_TARGTYPE_CHANGED"   , MQRC_ALIAS_TARGTYPE_CHANGED    },
         {"MQRC_ALREADY_CONNECTED"        , MQRC_ALREADY_CONNECTED         },
         {"MQRC_ALREADY_JOINED"           , MQRC_ALREADY_JOINED            },
         {"MQRC_ALTER_SUB_ERROR"          , MQRC_ALTER_SUB_ERROR           },
         {"MQRC_ANOTHER_Q_MGR_CONNECTED"  , MQRC_ANOTHER_Q_MGR_CONNECTED   },
         {"MQRC_API_EXIT_ERROR"           , MQRC_API_EXIT_ERROR            },
         {"MQRC_API_EXIT_INIT_ERROR"      , MQRC_API_EXIT_INIT_ERROR       },
         {"MQRC_API_EXIT_LOAD_ERROR"      , MQRC_API_EXIT_LOAD_ERROR       },
         {"MQRC_API_EXIT_NOT_FOUND"       , MQRC_API_EXIT_NOT_FOUND        },
         {"MQRC_API_EXIT_TERM_ERROR"      , MQRC_API_EXIT_TERM_ERROR       },
         {"MQRC_APPL_FIRST"               , MQRC_APPL_FIRST                },
         {"MQRC_APPL_LAST"                , MQRC_APPL_LAST                 },
         {"MQRC_ASID_MISMATCH"            , MQRC_ASID_MISMATCH             },
         {"MQRC_ASYNC_UOW_CONFLICT"       , MQRC_ASYNC_UOW_CONFLICT        },
         {"MQRC_ASYNC_XA_CONFLICT"        , MQRC_ASYNC_XA_CONFLICT         },
         {"MQRC_ATTRIBUTE_LOCKED"         , MQRC_ATTRIBUTE_LOCKED          },
         {"MQRC_AUTH_INFO_CONN_NAME_ERROR", MQRC_AUTH_INFO_CONN_NAME_ERROR },
         {"MQRC_AUTH_INFO_REC_COUNT_ERROR", MQRC_AUTH_INFO_REC_COUNT_ERROR },
         {"MQRC_AUTH_INFO_REC_ERROR"      , MQRC_AUTH_INFO_REC_ERROR       },
         {"MQRC_AUTH_INFO_TYPE_ERROR"     , MQRC_AUTH_INFO_TYPE_ERROR      },
         {"MQRC_BACKED_OUT"               , MQRC_BACKED_OUT                },
         {"MQRC_BACKOUT_THRESHOLD_REACHED", MQRC_BACKOUT_THRESHOLD_REACHED },
         {"MQRC_BAG_CONVERSION_ERROR"     , MQRC_BAG_CONVERSION_ERROR      },
         {"MQRC_BAG_WRONG_TYPE"           , MQRC_BAG_WRONG_TYPE            },
         {"MQRC_BINARY_DATA_LENGTH_ERROR" , MQRC_BINARY_DATA_LENGTH_ERROR  },
         {"MQRC_BMHO_ERROR"               , MQRC_BMHO_ERROR                },
         {"MQRC_BO_ERROR"                 , MQRC_BO_ERROR                  },
         {"MQRC_BRIDGE_STARTED"           , MQRC_BRIDGE_STARTED            },
         {"MQRC_BRIDGE_STOPPED"           , MQRC_BRIDGE_STOPPED            },
         {"MQRC_BUFFER_ERROR"             , MQRC_BUFFER_ERROR              },
         {"MQRC_BUFFER_LENGTH_ERROR"      , MQRC_BUFFER_LENGTH_ERROR       },
         {"MQRC_BUFFER_NOT_AUTOMATIC"     , MQRC_BUFFER_NOT_AUTOMATIC      },
         {"MQRC_CALL_IN_PROGRESS"         , MQRC_CALL_IN_PROGRESS          },
         {"MQRC_CALLBACK_LINK_ERROR"      , MQRC_CALLBACK_LINK_ERROR       },
         {"MQRC_CALLBACK_NOT_REGISTERED"  , MQRC_CALLBACK_NOT_REGISTERED   },
         {"MQRC_CALLBACK_ROUTINE_ERROR"   , MQRC_CALLBACK_ROUTINE_ERROR    },
         {"MQRC_CALLBACK_TYPE_ERROR"      , MQRC_CALLBACK_TYPE_ERROR       },
         {"MQRC_CBD_ERROR"                , MQRC_CBD_ERROR                 },
         {"MQRC_CBD_OPTIONS_ERROR"        , MQRC_CBD_OPTIONS_ERROR         },
         {"MQRC_CD_ERROR"                 , MQRC_CD_ERROR                  },
         {"MQRC_CF_NOT_AVAILABLE"         , MQRC_CF_NOT_AVAILABLE          },
         {"MQRC_CF_STRUC_AUTH_FAILED"     , MQRC_CF_STRUC_AUTH_FAILED      },
         {"MQRC_CF_STRUC_ERROR"           , MQRC_CF_STRUC_ERROR            },
         {"MQRC_CF_STRUC_FAILED"          , MQRC_CF_STRUC_FAILED           },
         {"MQRC_CF_STRUC_IN_USE"          , MQRC_CF_STRUC_IN_USE           },
         {"MQRC_CF_STRUC_LIST_HDR_IN_USE" , MQRC_CF_STRUC_LIST_HDR_IN_USE  },
         {"MQRC_CFBF_ERROR"               , MQRC_CFBF_ERROR                },
         {"MQRC_CFBS_ERROR"               , MQRC_CFBS_ERROR                },
         {"MQRC_CFGR_ERROR"               , MQRC_CFGR_ERROR                },
         {"MQRC_CFH_ERROR"                , MQRC_CFH_ERROR                 },
         {"MQRC_CFIF_ERROR"               , MQRC_CFIF_ERROR                },
         {"MQRC_CFIL_ERROR"               , MQRC_CFIL_ERROR                },
         {"MQRC_CFIN_ERROR"               , MQRC_CFIN_ERROR                },
         {"MQRC_CFSF_ERROR"               , MQRC_CFSF_ERROR                },
         {"MQRC_CFSL_ERROR"               , MQRC_CFSL_ERROR                },
         {"MQRC_CFST_ERROR"               , MQRC_CFST_ERROR                },
         {"MQRC_CHANNEL_ACTIVATED"        , MQRC_CHANNEL_ACTIVATED         },
         {"MQRC_CHANNEL_AUTO_DEF_ERROR"   , MQRC_CHANNEL_AUTO_DEF_ERROR    },
         {"MQRC_CHANNEL_AUTO_DEF_OK"      , MQRC_CHANNEL_AUTO_DEF_OK       },
         {"MQRC_CHANNEL_CONFIG_ERROR"     , MQRC_CHANNEL_CONFIG_ERROR      },
         {"MQRC_CHANNEL_CONV_ERROR"       , MQRC_CHANNEL_CONV_ERROR        },
         {"MQRC_CHANNEL_NOT_ACTIVATED"    , MQRC_CHANNEL_NOT_ACTIVATED     },
         {"MQRC_CHANNEL_NOT_AVAILABLE"    , MQRC_CHANNEL_NOT_AVAILABLE     },
         {"MQRC_CHANNEL_SSL_ERROR"        , MQRC_CHANNEL_SSL_ERROR         },
         {"MQRC_CHANNEL_SSL_WARNING"      , MQRC_CHANNEL_SSL_WARNING       },
         {"MQRC_CHANNEL_STARTED"          , MQRC_CHANNEL_STARTED           },
         {"MQRC_CHANNEL_STOPPED"          , MQRC_CHANNEL_STOPPED           },
         {"MQRC_CHANNEL_STOPPED_BY_USER"  , MQRC_CHANNEL_STOPPED_BY_USER   },
         {"MQRC_CHAR_ATTR_LENGTH_ERROR"   , MQRC_CHAR_ATTR_LENGTH_ERROR    },
         {"MQRC_CHAR_ATTRS_ERROR"         , MQRC_CHAR_ATTRS_ERROR          },
         {"MQRC_CHAR_ATTRS_TOO_SHORT"     , MQRC_CHAR_ATTRS_TOO_SHORT      },
         {"MQRC_CHAR_CONVERSION_ERROR"    , MQRC_CHAR_CONVERSION_ERROR     },
         {"MQRC_CICS_BRIDGE_RESTRICTION"  , MQRC_CICS_BRIDGE_RESTRICTION   },
         {"MQRC_CICS_WAIT_FAILED"         , MQRC_CICS_WAIT_FAILED          },
         {"MQRC_CLIENT_CHANNEL_CONFLICT"  , MQRC_CLIENT_CHANNEL_CONFLICT   },
         {"MQRC_CLIENT_CONN_ERROR"        , MQRC_CLIENT_CONN_ERROR         },
         {"MQRC_CLIENT_EXIT_ERROR"        , MQRC_CLIENT_EXIT_ERROR         },
         {"MQRC_CLIENT_EXIT_LOAD_ERROR"   , MQRC_CLIENT_EXIT_LOAD_ERROR    },
         {"MQRC_CLUSTER_EXIT_ERROR"       , MQRC_CLUSTER_EXIT_ERROR        },
         {"MQRC_CLUSTER_EXIT_LOAD_ERROR"  , MQRC_CLUSTER_EXIT_LOAD_ERROR   },
         {"MQRC_CLUSTER_PUT_INHIBITED"    , MQRC_CLUSTER_PUT_INHIBITED     },
         {"MQRC_CLUSTER_RESOLUTION_ERROR" , MQRC_CLUSTER_RESOLUTION_ERROR  },
         {"MQRC_CLUSTER_RESOURCE_ERROR"   , MQRC_CLUSTER_RESOURCE_ERROR    },
         {"MQRC_CMD_SERVER_NOT_AVAILABLE" , MQRC_CMD_SERVER_NOT_AVAILABLE  },
         {"MQRC_CMHO_ERROR"               , MQRC_CMHO_ERROR                },
         {"MQRC_CNO_ERROR"                , MQRC_CNO_ERROR                 },
         {"MQRC_COD_NOT_VALID_FOR_XCF_Q"  , MQRC_COD_NOT_VALID_FOR_XCF_Q   },
         {"MQRC_CODED_CHAR_SET_ID_ERROR"  , MQRC_CODED_CHAR_SET_ID_ERROR   },
         {"MQRC_COMMAND_MQSC"             , MQRC_COMMAND_MQSC              },
         {"MQRC_COMMAND_PCF"              , MQRC_COMMAND_PCF               },
         {"MQRC_COMMAND_TYPE_ERROR"       , MQRC_COMMAND_TYPE_ERROR        },
         {"MQRC_CONFIG_CHANGE_OBJECT"     , MQRC_CONFIG_CHANGE_OBJECT      },
         {"MQRC_CONFIG_CREATE_OBJECT"     , MQRC_CONFIG_CREATE_OBJECT      },
         {"MQRC_CONFIG_DELETE_OBJECT"     , MQRC_CONFIG_DELETE_OBJECT      },
         {"MQRC_CONFIG_REFRESH_OBJECT"    , MQRC_CONFIG_REFRESH_OBJECT     },
         {"MQRC_CONN_ID_IN_USE"           , MQRC_CONN_ID_IN_USE            },
         {"MQRC_CONN_TAG_IN_USE"          , MQRC_CONN_TAG_IN_USE           },
         {"MQRC_CONN_TAG_NOT_RELEASED"    , MQRC_CONN_TAG_NOT_RELEASED     },
         {"MQRC_CONN_TAG_NOT_USABLE"      , MQRC_CONN_TAG_NOT_USABLE       },
         {"MQRC_CONNECTION_BROKEN"        , MQRC_CONNECTION_BROKEN         },
         {"MQRC_CONNECTION_ERROR"         , MQRC_CONNECTION_ERROR          },
         {"MQRC_CONNECTION_NOT_AUTHORIZED", MQRC_CONNECTION_NOT_AUTHORIZED },
         {"MQRC_CONNECTION_QUIESCING"     , MQRC_CONNECTION_QUIESCING      },
         {"MQRC_CONNECTION_STOPPED"       , MQRC_CONNECTION_STOPPED        },
         {"MQRC_CONNECTION_STOPPING"      , MQRC_CONNECTION_STOPPING       },
         {"MQRC_CONNECTION_SUSPENDED"     , MQRC_CONNECTION_SUSPENDED      },
         {"MQRC_CONTEXT_HANDLE_ERROR"     , MQRC_CONTEXT_HANDLE_ERROR      },
         {"MQRC_CONTEXT_NOT_AVAILABLE"    , MQRC_CONTEXT_NOT_AVAILABLE     },
         {"MQRC_CONTEXT_OBJECT_NOT_VALID" , MQRC_CONTEXT_OBJECT_NOT_VALID  },
         {"MQRC_CONTEXT_OPEN_ERROR"       , MQRC_CONTEXT_OPEN_ERROR        },
         {"MQRC_CONVERTED_MSG_TOO_BIG"    , MQRC_CONVERTED_MSG_TOO_BIG     },
         {"MQRC_CONVERTED_STRING_TOO_BIG" , MQRC_CONVERTED_STRING_TOO_BIG  },
         {"MQRC_CORREL_ID_ERROR"          , MQRC_CORREL_ID_ERROR           },
         {"MQRC_CRYPTO_HARDWARE_ERROR"    , MQRC_CRYPTO_HARDWARE_ERROR     },
         {"MQRC_CTLO_ERROR"               , MQRC_CTLO_ERROR                },
         {"MQRC_CURRENT_RECORD_ERROR"     , MQRC_CURRENT_RECORD_ERROR      },
         {"MQRC_CURSOR_NOT_VALID"         , MQRC_CURSOR_NOT_VALID          },
         {"MQRC_DATA_LENGTH_ERROR"        , MQRC_DATA_LENGTH_ERROR         },
         {"MQRC_DATA_TRUNCATED"           , MQRC_DATA_TRUNCATED            },
         {"MQRC_DB2_NOT_AVAILABLE"        , MQRC_DB2_NOT_AVAILABLE         },
         {"MQRC_DBCS_ERROR"               , MQRC_DBCS_ERROR                },
         {"MQRC_DEF_XMIT_Q_TYPE_ERROR"    , MQRC_DEF_XMIT_Q_TYPE_ERROR     },
         {"MQRC_DEF_XMIT_Q_USAGE_ERROR"   , MQRC_DEF_XMIT_Q_USAGE_ERROR    },
         {"MQRC_DEST_CLASS_NOT_ALTERABLE" , MQRC_DEST_CLASS_NOT_ALTERABLE  },
         {"MQRC_DEST_ENV_ERROR"           , MQRC_DEST_ENV_ERROR            },
         {"MQRC_DEST_NAME_ERROR"          , MQRC_DEST_NAME_ERROR           },
         {"MQRC_DH_ERROR"                 , MQRC_DH_ERROR                  },
         {"MQRC_DISTRIBUTION_LIST_EMPTY"  , MQRC_DISTRIBUTION_LIST_EMPTY   },
         {"MQRC_DLH_ERROR"                , MQRC_DLH_ERROR                 },
         {"MQRC_DMHO_ERROR"               , MQRC_DMHO_ERROR                },
         {"MQRC_DMPO_ERROR"               , MQRC_DMPO_ERROR                },
         {"MQRC_DUPLICATE_GROUP_SUB"      , MQRC_DUPLICATE_GROUP_SUB       },
         {"MQRC_DUPLICATE_RECOV_COORD"    , MQRC_DUPLICATE_RECOV_COORD     },
         {"MQRC_DURABILITY_NOT_ALLOWED"   , MQRC_DURABILITY_NOT_ALLOWED    },
         {"MQRC_DURABILITY_NOT_ALTERABLE" , MQRC_DURABILITY_NOT_ALTERABLE  },
         {"MQRC_DYNAMIC_Q_NAME_ERROR"     , MQRC_DYNAMIC_Q_NAME_ERROR      },
         {"MQRC_ENCODING_ERROR"           , MQRC_ENCODING_ERROR            },
         {"MQRC_ENCODING_NOT_SUPPORTED"   , MQRC_ENCODING_NOT_SUPPORTED    },
         {"MQRC_ENVIRONMENT_ERROR"        , MQRC_ENVIRONMENT_ERROR         },
         {"MQRC_EPH_ERROR"                , MQRC_EPH_ERROR                 },
         {"MQRC_EXIT_REASON_ERROR"        , MQRC_EXIT_REASON_ERROR         },
         {"MQRC_EXPIRY_ERROR"             , MQRC_EXPIRY_ERROR              },
         {"MQRC_FEEDBACK_ERROR"           , MQRC_FEEDBACK_ERROR            },
         {"MQRC_FILE_NOT_AUDITED"         , MQRC_FILE_NOT_AUDITED          },
         {"MQRC_FILE_SYSTEM_ERROR"        , MQRC_FILE_SYSTEM_ERROR         },
         {"MQRC_FILTER_OPERATOR_ERROR"    , MQRC_FILTER_OPERATOR_ERROR     },
         {"MQRC_FORMAT_ERROR"             , MQRC_FORMAT_ERROR              },
         {"MQRC_FORMAT_NOT_SUPPORTED"     , MQRC_FORMAT_NOT_SUPPORTED      },
         {"MQRC_FUNCTION_ERROR"           , MQRC_FUNCTION_ERROR            },
         {"MQRC_FUNCTION_NOT_SUPPORTED"   , MQRC_FUNCTION_NOT_SUPPORTED    },
         {"MQRC_GET_ENABLED"              , MQRC_GET_ENABLED               },
         {"MQRC_GET_INHIBITED"            , MQRC_GET_INHIBITED             },
         {"MQRC_GLOBAL_UOW_CONFLICT"      , MQRC_GLOBAL_UOW_CONFLICT       },
         {"MQRC_GMO_ERROR"                , MQRC_GMO_ERROR                 },
         {"MQRC_GROUP_ID_ERROR"           , MQRC_GROUP_ID_ERROR            },
         {"MQRC_GROUPING_NOT_ALTERABLE"   , MQRC_GROUPING_NOT_ALTERABLE    },
         {"MQRC_HANDLE_IN_USE_FOR_UOW"    , MQRC_HANDLE_IN_USE_FOR_UOW     },
         {"MQRC_HANDLE_NOT_AVAILABLE"     , MQRC_HANDLE_NOT_AVAILABLE      },
         {"MQRC_HBAG_ERROR"               , MQRC_HBAG_ERROR                },
         {"MQRC_HCONFIG_ERROR"            , MQRC_HCONFIG_ERROR             },
         {"MQRC_HCONN_ASYNC_ACTIVE"       , MQRC_HCONN_ASYNC_ACTIVE        },
         {"MQRC_HCONN_ERROR"              , MQRC_HCONN_ERROR               },
         {"MQRC_HEADER_ERROR"             , MQRC_HEADER_ERROR              },
         {"MQRC_HMSG_ERROR"               , MQRC_HMSG_ERROR                },
         {"MQRC_HOBJ_ERROR"               , MQRC_HOBJ_ERROR                },
         {"MQRC_HOBJ_QUIESCED"            , MQRC_HOBJ_QUIESCED             },
         {"MQRC_HOBJ_QUIESCED_NO_MSGS"    , MQRC_HOBJ_QUIESCED_NO_MSGS     },
         {"MQRC_HOST_NOT_AVAILABLE"       , MQRC_HOST_NOT_AVAILABLE        },
         {"MQRC_IDENTITY_MISMATCH"        , MQRC_IDENTITY_MISMATCH         },
         {"MQRC_IIH_ERROR"                , MQRC_IIH_ERROR                 },
         {"MQRC_IMPO_ERROR"               , MQRC_IMPO_ERROR                },
         {"MQRC_INCOMPLETE_GROUP"         , MQRC_INCOMPLETE_GROUP          },
         {"MQRC_INCOMPLETE_MSG"           , MQRC_INCOMPLETE_MSG            },
         {"MQRC_INCONSISTENT_BROWSE"      , MQRC_INCONSISTENT_BROWSE       },
         {"MQRC_INCONSISTENT_CCSIDS"      , MQRC_INCONSISTENT_CCSIDS       },
         {"MQRC_INCONSISTENT_ENCODINGS"   , MQRC_INCONSISTENT_ENCODINGS    },
         {"MQRC_INCONSISTENT_FORMAT"      , MQRC_INCONSISTENT_FORMAT       },
         {"MQRC_INCONSISTENT_ITEM_TYPE"   , MQRC_INCONSISTENT_ITEM_TYPE    },
         {"MQRC_INCONSISTENT_OBJECT_STATE", MQRC_INCONSISTENT_OBJECT_STATE },
         {"MQRC_INCONSISTENT_OPEN_OPTIONS", MQRC_INCONSISTENT_OPEN_OPTIONS },
         {"MQRC_INCONSISTENT_PERSISTENCE" , MQRC_INCONSISTENT_PERSISTENCE  },
         {"MQRC_INCONSISTENT_UOW"         , MQRC_INCONSISTENT_UOW          },
         {"MQRC_INDEX_ERROR"              , MQRC_INDEX_ERROR               },
         {"MQRC_INDEX_NOT_PRESENT"        , MQRC_INDEX_NOT_PRESENT         },
         {"MQRC_INHIBIT_VALUE_ERROR"      , MQRC_INHIBIT_VALUE_ERROR       },
         {"MQRC_INITIALIZATION_FAILED"    , MQRC_INITIALIZATION_FAILED     },
         {"MQRC_INQUIRY_COMMAND_ERROR"    , MQRC_INQUIRY_COMMAND_ERROR     },
         {"MQRC_INSUFFICIENT_BUFFER"      , MQRC_INSUFFICIENT_BUFFER       },
         {"MQRC_INSUFFICIENT_DATA"        , MQRC_INSUFFICIENT_DATA         },
         {"MQRC_INT_ATTR_COUNT_ERROR"     , MQRC_INT_ATTR_COUNT_ERROR      },
         {"MQRC_INT_ATTR_COUNT_TOO_SMALL" , MQRC_INT_ATTR_COUNT_TOO_SMALL  },
         {"MQRC_INT_ATTRS_ARRAY_ERROR"    , MQRC_INT_ATTRS_ARRAY_ERROR     },
         {"MQRC_INVALID_DESTINATION"      , MQRC_INVALID_DESTINATION       },
         {"MQRC_INVALID_MSG_UNDER_CURSOR" , MQRC_INVALID_MSG_UNDER_CURSOR  },
         {"MQRC_INVALID_SUBSCRIPTION"     , MQRC_INVALID_SUBSCRIPTION      },
         {"MQRC_ITEM_COUNT_ERROR"         , MQRC_ITEM_COUNT_ERROR          },
         {"MQRC_ITEM_TYPE_ERROR"          , MQRC_ITEM_TYPE_ERROR           },
         {"MQRC_ITEM_VALUE_ERROR"         , MQRC_ITEM_VALUE_ERROR          },
         {"MQRC_JMS_FORMAT_ERROR"         , MQRC_JMS_FORMAT_ERROR          },
         {"MQRC_JSSE_ERROR"               , MQRC_JSSE_ERROR                },
         {"MQRC_KEY_REPOSITORY_ERROR"     , MQRC_KEY_REPOSITORY_ERROR      },
         {"MQRC_LDAP_PASSWORD_ERROR"      , MQRC_LDAP_PASSWORD_ERROR       },
         {"MQRC_LDAP_USER_NAME_ERROR"     , MQRC_LDAP_USER_NAME_ERROR      },
         {"MQRC_LDAP_USER_NAME_LENGTH_ERR", MQRC_LDAP_USER_NAME_LENGTH_ERR },
         {"MQRC_LOCAL_UOW_CONFLICT"       , MQRC_LOCAL_UOW_CONFLICT        },
         {"MQRC_LOGGER_STATUS"            , MQRC_LOGGER_STATUS             },
         {"MQRC_LOOPING_PUBLICATION"      , MQRC_LOOPING_PUBLICATION       },
         {"MQRC_MATCH_OPTIONS_ERROR"      , MQRC_MATCH_OPTIONS_ERROR       },
         {"MQRC_MAX_CONNS_LIMIT_REACHED"  , MQRC_MAX_CONNS_LIMIT_REACHED   },
         {"MQRC_MAX_MSG_LENGTH_ERROR"     , MQRC_MAX_MSG_LENGTH_ERROR      },
         {"MQRC_MD_ERROR"                 , MQRC_MD_ERROR                  },
         {"MQRC_MDE_ERROR"                , MQRC_MDE_ERROR                 },
         {"MQRC_MHBO_ERROR"               , MQRC_MHBO_ERROR                },
         {"MQRC_MISSING_REPLY_TO_Q"       , MQRC_MISSING_REPLY_TO_Q        },
         {"MQRC_MISSING_WIH"              , MQRC_MISSING_WIH               },
         {"MQRC_MIXED_CONTENT_NOT_ALLOWED", MQRC_MIXED_CONTENT_NOT_ALLOWED },
         {"MQRC_MODULE_ENTRY_NOT_FOUND"   , MQRC_MODULE_ENTRY_NOT_FOUND    },
         {"MQRC_MODULE_INVALID"           , MQRC_MODULE_INVALID            },
         {"MQRC_MODULE_NOT_FOUND"         , MQRC_MODULE_NOT_FOUND          },
         {"MQRC_MSG_FLAGS_ERROR"          , MQRC_MSG_FLAGS_ERROR           },
         {"MQRC_MSG_HANDLE_COPY_FAILURE"  , MQRC_MSG_HANDLE_COPY_FAILURE   },
         {"MQRC_MSG_HANDLE_IN_USE"        , MQRC_MSG_HANDLE_IN_USE         },
         {"MQRC_MSG_ID_ERROR"             , MQRC_MSG_ID_ERROR              },
         {"MQRC_MSG_MARKED_BROWSE_CO_OP"  , MQRC_MSG_MARKED_BROWSE_CO_OP   },
         {"MQRC_MSG_NOT_ALLOWED_IN_GROUP" , MQRC_MSG_NOT_ALLOWED_IN_GROUP  },
         {"MQRC_MSG_NOT_MATCHED"          , MQRC_MSG_NOT_MATCHED           },
         {"MQRC_MSG_SEQ_NUMBER_ERROR"     , MQRC_MSG_SEQ_NUMBER_ERROR      },
         {"MQRC_MSG_TOKEN_ERROR"          , MQRC_MSG_TOKEN_ERROR           },
         {"MQRC_MSG_TOO_BIG_FOR_CHANNEL"  , MQRC_MSG_TOO_BIG_FOR_CHANNEL   },
         {"MQRC_MSG_TOO_BIG_FOR_Q"        , MQRC_MSG_TOO_BIG_FOR_Q         },
         {"MQRC_MSG_TOO_BIG_FOR_Q_MGR"    , MQRC_MSG_TOO_BIG_FOR_Q_MGR     },
         {"MQRC_MSG_TYPE_ERROR"           , MQRC_MSG_TYPE_ERROR            },
         {"MQRC_MULTIPLE_INSTANCE_ERROR"  , MQRC_MULTIPLE_INSTANCE_ERROR   },
         {"MQRC_MULTIPLE_REASONS"         , MQRC_MULTIPLE_REASONS          },
         {"MQRC_NAME_IN_USE"              , MQRC_NAME_IN_USE               },
         {"MQRC_NAME_NOT_VALID_FOR_TYPE"  , MQRC_NAME_NOT_VALID_FOR_TYPE   },
         {"MQRC_NEGATIVE_LENGTH"          , MQRC_NEGATIVE_LENGTH           },
         {"MQRC_NEGATIVE_OFFSET"          , MQRC_NEGATIVE_OFFSET           },
         {"MQRC_NESTED_BAG_NOT_SUPPORTED" , MQRC_NESTED_BAG_NOT_SUPPORTED  },
         {"MQRC_NESTED_SELECTOR_ERROR"    , MQRC_NESTED_SELECTOR_ERROR     },
         {"MQRC_NEXT_OFFSET_ERROR"        , MQRC_NEXT_OFFSET_ERROR         },
         {"MQRC_NEXT_RECORD_ERROR"        , MQRC_NEXT_RECORD_ERROR         },
         {"MQRC_NO_BUFFER"                , MQRC_NO_BUFFER                 },
         {"MQRC_NO_CALLBACKS_ACTIVE"      , MQRC_NO_CALLBACKS_ACTIVE       },
         {"MQRC_NO_CONNECTION_REFERENCE"  , MQRC_NO_CONNECTION_REFERENCE   },
         {"MQRC_NO_DATA_AVAILABLE"        , MQRC_NO_DATA_AVAILABLE         },
         {"MQRC_NO_DESTINATIONS_AVAILABLE", MQRC_NO_DESTINATIONS_AVAILABLE },
         {"MQRC_NO_EXTERNAL_PARTICIPANTS" , MQRC_NO_EXTERNAL_PARTICIPANTS  },
         {"MQRC_NO_MSG_AVAILABLE"         , MQRC_NO_MSG_AVAILABLE          },
         {"MQRC_NO_MSG_LOCKED"            , MQRC_NO_MSG_LOCKED             },
         {"MQRC_NO_MSG_UNDER_CURSOR"      , MQRC_NO_MSG_UNDER_CURSOR       },
         {"MQRC_NO_RECORD_AVAILABLE"      , MQRC_NO_RECORD_AVAILABLE       },
         {"MQRC_NO_RETAINED_MSG"          , MQRC_NO_RETAINED_MSG           },
         {"MQRC_NO_SUBSCRIPTION"          , MQRC_NO_SUBSCRIPTION           },
         {"MQRC_NONE"                     , MQRC_NONE                      },
         {"MQRC_NOT_AUTHORIZED"           , MQRC_NOT_AUTHORIZED            },
         {"MQRC_NOT_CONNECTED"            , MQRC_NOT_CONNECTED             },
         {"MQRC_NOT_CONVERTED"            , MQRC_NOT_CONVERTED             },
         {"MQRC_NOT_OPEN"                 , MQRC_NOT_OPEN                  },
         {"MQRC_NOT_OPEN_FOR_BROWSE"      , MQRC_NOT_OPEN_FOR_BROWSE       },
         {"MQRC_NOT_OPEN_FOR_INPUT"       , MQRC_NOT_OPEN_FOR_INPUT        },
         {"MQRC_NOT_OPEN_FOR_INQUIRE"     , MQRC_NOT_OPEN_FOR_INQUIRE      },
         {"MQRC_NOT_OPEN_FOR_OUTPUT"      , MQRC_NOT_OPEN_FOR_OUTPUT       },
         {"MQRC_NOT_OPEN_FOR_PASS_ALL"    , MQRC_NOT_OPEN_FOR_PASS_ALL     },
         {"MQRC_NOT_OPEN_FOR_PASS_IDENT"  , MQRC_NOT_OPEN_FOR_PASS_IDENT   },
         {"MQRC_NOT_OPEN_FOR_SET"         , MQRC_NOT_OPEN_FOR_SET          },
         {"MQRC_NOT_OPEN_FOR_SET_ALL"     , MQRC_NOT_OPEN_FOR_SET_ALL      },
         {"MQRC_NOT_OPEN_FOR_SET_IDENT"   , MQRC_NOT_OPEN_FOR_SET_IDENT    },
         {"MQRC_NULL_POINTER"             , MQRC_NULL_POINTER              },
         {"MQRC_OBJECT_ALREADY_EXISTS"    , MQRC_OBJECT_ALREADY_EXISTS     },
         {"MQRC_OBJECT_CHANGED"           , MQRC_OBJECT_CHANGED            },
         {"MQRC_OBJECT_DAMAGED"           , MQRC_OBJECT_DAMAGED            },
         {"MQRC_OBJECT_IN_USE"            , MQRC_OBJECT_IN_USE             },
         {"MQRC_OBJECT_LEVEL_INCOMPATIBLE", MQRC_OBJECT_LEVEL_INCOMPATIBLE },
         {"MQRC_OBJECT_NAME_ERROR"        , MQRC_OBJECT_NAME_ERROR         },
         {"MQRC_OBJECT_NOT_UNIQUE"        , MQRC_OBJECT_NOT_UNIQUE         },
         {"MQRC_OBJECT_Q_MGR_NAME_ERROR"  , MQRC_OBJECT_Q_MGR_NAME_ERROR   },
         {"MQRC_OBJECT_RECORDS_ERROR"     , MQRC_OBJECT_RECORDS_ERROR      },
         {"MQRC_OBJECT_STRING_ERROR"      , MQRC_OBJECT_STRING_ERROR       },
         {"MQRC_OBJECT_TYPE_ERROR"        , MQRC_OBJECT_TYPE_ERROR         },
         {"MQRC_OCSP_URL_ERROR"           , MQRC_OCSP_URL_ERROR            },
         {"MQRC_OD_ERROR"                 , MQRC_OD_ERROR                  },
         {"MQRC_OFFSET_ERROR"             , MQRC_OFFSET_ERROR              },
         {"MQRC_OPEN_FAILED"              , MQRC_OPEN_FAILED               },
         {"MQRC_OPERATION_ERROR"          , MQRC_OPERATION_ERROR           },
         {"MQRC_OPERATION_NOT_ALLOWED"    , MQRC_OPERATION_NOT_ALLOWED     },
         {"MQRC_OPTION_ENVIRONMENT_ERROR" , MQRC_OPTION_ENVIRONMENT_ERROR  },
         {"MQRC_OPTION_NOT_VALID_FOR_TYPE", MQRC_OPTION_NOT_VALID_FOR_TYPE },
         {"MQRC_OPTIONS_CHANGED"          , MQRC_OPTIONS_CHANGED           },
         {"MQRC_OPTIONS_ERROR"            , MQRC_OPTIONS_ERROR             },
         {"MQRC_ORIGINAL_LENGTH_ERROR"    , MQRC_ORIGINAL_LENGTH_ERROR     },
         {"MQRC_OUT_SELECTOR_ERROR"       , MQRC_OUT_SELECTOR_ERROR        },
         {"MQRC_OUTCOME_MIXED"            , MQRC_OUTCOME_MIXED             },
         {"MQRC_OUTCOME_PENDING"          , MQRC_OUTCOME_PENDING           },
         {"MQRC_PAGESET_ERROR"            , MQRC_PAGESET_ERROR             },
         {"MQRC_PAGESET_FULL"             , MQRC_PAGESET_FULL              },
         {"MQRC_PARAMETER_MISSING"        , MQRC_PARAMETER_MISSING         },
         {"MQRC_PARTIALLY_CONVERTED"      , MQRC_PARTIALLY_CONVERTED       },
         {"MQRC_PARTICIPANT_NOT_AVAILABLE", MQRC_PARTICIPANT_NOT_AVAILABLE },
         {"MQRC_PARTICIPANT_NOT_DEFINED"  , MQRC_PARTICIPANT_NOT_DEFINED   },
         {"MQRC_PCF_ERROR"                , MQRC_PCF_ERROR                 },
         {"MQRC_PD_ERROR"                 , MQRC_PD_ERROR                  },
         {"MQRC_PERSISTENCE_ERROR"        , MQRC_PERSISTENCE_ERROR         },
         {"MQRC_PERSISTENT_NOT_ALLOWED"   , MQRC_PERSISTENT_NOT_ALLOWED    },
         {"MQRC_PMO_ERROR"                , MQRC_PMO_ERROR                 },
         {"MQRC_PMO_RECORD_FLAGS_ERROR"   , MQRC_PMO_RECORD_FLAGS_ERROR    },
         {"MQRC_PRIORITY_ERROR"           , MQRC_PRIORITY_ERROR            },
         {"MQRC_PRIORITY_EXCEEDS_MAXIMUM" , MQRC_PRIORITY_EXCEEDS_MAXIMUM  },
         {"MQRC_PROP_CONV_NOT_SUPPORTED"  , MQRC_PROP_CONV_NOT_SUPPORTED   },
         {"MQRC_PROP_NAME_NOT_CONVERTED"  , MQRC_PROP_NAME_NOT_CONVERTED   },
         {"MQRC_PROP_NUMBER_FORMAT_ERROR" , MQRC_PROP_NUMBER_FORMAT_ERROR  },
         {"MQRC_PROP_TYPE_NOT_SUPPORTED"  , MQRC_PROP_TYPE_NOT_SUPPORTED   },
         {"MQRC_PROP_VALUE_NOT_CONVERTED" , MQRC_PROP_VALUE_NOT_CONVERTED  },
         {"MQRC_PROPERTIES_TOO_BIG"       , MQRC_PROPERTIES_TOO_BIG        },
         {"MQRC_PROPERTY_NAME_ERROR"      , MQRC_PROPERTY_NAME_ERROR       },
         {"MQRC_PROPERTY_NAME_LENGTH_ERR" , MQRC_PROPERTY_NAME_LENGTH_ERR  },
         {"MQRC_PROPERTY_NAME_TOO_BIG"    , MQRC_PROPERTY_NAME_TOO_BIG     },
         {"MQRC_PROPERTY_NOT_AVAILABLE"   , MQRC_PROPERTY_NOT_AVAILABLE    },
         {"MQRC_PROPERTY_TYPE_ERROR"      , MQRC_PROPERTY_TYPE_ERROR       },
         {"MQRC_PROPERTY_VALUE_TOO_BIG"   , MQRC_PROPERTY_VALUE_TOO_BIG    },
         {"MQRC_PUBLICATION_FAILURE"      , MQRC_PUBLICATION_FAILURE       },
         {"MQRC_PUBSUB_INHIBITED"         , MQRC_PUBSUB_INHIBITED          },
         {"MQRC_PUT_INHIBITED"            , MQRC_PUT_INHIBITED             },
         {"MQRC_PUT_MSG_RECORDS_ERROR"    , MQRC_PUT_MSG_RECORDS_ERROR     },
         {"MQRC_PUT_NOT_RETAINED"         , MQRC_PUT_NOT_RETAINED          },
         {"MQRC_Q_ALREADY_EXISTS"         , MQRC_Q_ALREADY_EXISTS          },
         {"MQRC_Q_DELETED"                , MQRC_Q_DELETED                 },
         {"MQRC_Q_DEPTH_HIGH"             , MQRC_Q_DEPTH_HIGH              },
         {"MQRC_Q_DEPTH_LOW"              , MQRC_Q_DEPTH_LOW               },
         {"MQRC_Q_FULL"                   , MQRC_Q_FULL                    },
         {"MQRC_Q_INDEX_TYPE_ERROR"       , MQRC_Q_INDEX_TYPE_ERROR        },
         {"MQRC_Q_MGR_ACTIVE"             , MQRC_Q_MGR_ACTIVE              },
         {"MQRC_Q_MGR_NAME_ERROR"         , MQRC_Q_MGR_NAME_ERROR          },
         {"MQRC_Q_MGR_NOT_ACTIVE"         , MQRC_Q_MGR_NOT_ACTIVE          },
         {"MQRC_Q_MGR_NOT_AVAILABLE"      , MQRC_Q_MGR_NOT_AVAILABLE       },
         {"MQRC_Q_MGR_QUIESCING"          , MQRC_Q_MGR_QUIESCING           },
         {"MQRC_Q_MGR_STOPPING"           , MQRC_Q_MGR_STOPPING            },
         {"MQRC_Q_NOT_EMPTY"              , MQRC_Q_NOT_EMPTY               },
         {"MQRC_Q_SERVICE_INTERVAL_HIGH"  , MQRC_Q_SERVICE_INTERVAL_HIGH   },
         {"MQRC_Q_SERVICE_INTERVAL_OK"    , MQRC_Q_SERVICE_INTERVAL_OK     },
         {"MQRC_Q_SPACE_NOT_AVAILABLE"    , MQRC_Q_SPACE_NOT_AVAILABLE     },
         {"MQRC_Q_TYPE_ERROR"             , MQRC_Q_TYPE_ERROR              },
         {"MQRC_RAS_PROPERTY_ERROR"       , MQRC_RAS_PROPERTY_ERROR        },
         {"MQRC_READ_AHEAD_MSGS"          , MQRC_READ_AHEAD_MSGS           },
         {"MQRC_RECS_PRESENT_ERROR"       , MQRC_RECS_PRESENT_ERROR        },
         {"MQRC_REFERENCE_ERROR"          , MQRC_REFERENCE_ERROR           },
         {"MQRC_REMOTE_Q_NAME_ERROR"      , MQRC_REMOTE_Q_NAME_ERROR       },
         {"MQRC_REOPEN_EXCL_INPUT_ERROR"  , MQRC_REOPEN_EXCL_INPUT_ERROR   },
         {"MQRC_REOPEN_INQUIRE_ERROR"     , MQRC_REOPEN_INQUIRE_ERROR      },
         {"MQRC_REOPEN_SAVED_CONTEXT_ERR" , MQRC_REOPEN_SAVED_CONTEXT_ERR  },
         {"MQRC_REOPEN_TEMPORARY_Q_ERROR" , MQRC_REOPEN_TEMPORARY_Q_ERROR  },
         {"MQRC_REPORT_OPTIONS_ERROR"     , MQRC_REPORT_OPTIONS_ERROR      },
         {"MQRC_RES_OBJECT_STRING_ERROR"  , MQRC_RES_OBJECT_STRING_ERROR   },
         {"MQRC_RESERVED_VALUE_ERROR"     , MQRC_RESERVED_VALUE_ERROR      },
         {"MQRC_RESOURCE_PROBLEM"         , MQRC_RESOURCE_PROBLEM          },
         {"MQRC_RESPONSE_RECORDS_ERROR"   , MQRC_RESPONSE_RECORDS_ERROR    },
         {"MQRC_RETAINED_MSG_Q_ERROR"     , MQRC_RETAINED_MSG_Q_ERROR      },
         {"MQRC_RETAINED_NOT_DELIVERED"   , MQRC_RETAINED_NOT_DELIVERED    },
         {"MQRC_RFH_COMMAND_ERROR"        , MQRC_RFH_COMMAND_ERROR         },
         {"MQRC_RFH_DUPLICATE_PARM"       , MQRC_RFH_DUPLICATE_PARM        },
         {"MQRC_RFH_ERROR"                , MQRC_RFH_ERROR                 },
         {"MQRC_RFH_FORMAT_ERROR"         , MQRC_RFH_FORMAT_ERROR          },
         {"MQRC_RFH_HEADER_FIELD_ERROR"   , MQRC_RFH_HEADER_FIELD_ERROR    },
         {"MQRC_RFH_PARM_ERROR"           , MQRC_RFH_PARM_ERROR            },
         {"MQRC_RFH_PARM_MISSING"         , MQRC_RFH_PARM_MISSING          },
         {"MQRC_RFH_RESTRICTED_FORMAT_ERR", MQRC_RFH_RESTRICTED_FORMAT_ERR },
         {"MQRC_RFH_STRING_ERROR"         , MQRC_RFH_STRING_ERROR          },
         {"MQRC_RMH_ERROR"                , MQRC_RMH_ERROR                 },
         {"MQRC_SCO_ERROR"                , MQRC_SCO_ERROR                 },
         {"MQRC_SD_ERROR"                 , MQRC_SD_ERROR                  },
         {"MQRC_SECOND_MARK_NOT_ALLOWED"  , MQRC_SECOND_MARK_NOT_ALLOWED   },
         {"MQRC_SECURITY_ERROR"           , MQRC_SECURITY_ERROR            },
         {"MQRC_SEGMENT_LENGTH_ZERO"      , MQRC_SEGMENT_LENGTH_ZERO       },
         {"MQRC_SEGMENTATION_NOT_ALLOWED" , MQRC_SEGMENTATION_NOT_ALLOWED  },
         {"MQRC_SEGMENTS_NOT_SUPPORTED"   , MQRC_SEGMENTS_NOT_SUPPORTED    },
         {"MQRC_SELECTION_STRING_ERROR"   , MQRC_SELECTION_STRING_ERROR    },
         {"MQRC_SELECTOR_ALWAYS_FALSE"    , MQRC_SELECTOR_ALWAYS_FALSE     },
         {"MQRC_SELECTOR_COUNT_ERROR"     , MQRC_SELECTOR_COUNT_ERROR      },
         {"MQRC_SELECTOR_ERROR"           , MQRC_SELECTOR_ERROR            },
         {"MQRC_SELECTOR_INVALID_FOR_TYPE", MQRC_SELECTOR_INVALID_FOR_TYPE },
         {"MQRC_SELECTOR_LIMIT_EXCEEDED"  , MQRC_SELECTOR_LIMIT_EXCEEDED   },
         {"MQRC_SELECTOR_NOT_ALTERABLE"   , MQRC_SELECTOR_NOT_ALTERABLE    },
         {"MQRC_SELECTOR_NOT_FOR_TYPE"    , MQRC_SELECTOR_NOT_FOR_TYPE     },
         {"MQRC_SELECTOR_NOT_PRESENT"     , MQRC_SELECTOR_NOT_PRESENT      },
         {"MQRC_SELECTOR_NOT_SUPPORTED"   , MQRC_SELECTOR_NOT_SUPPORTED    },
         {"MQRC_SELECTOR_NOT_UNIQUE"      , MQRC_SELECTOR_NOT_UNIQUE       },
         {"MQRC_SELECTOR_OUT_OF_RANGE"    , MQRC_SELECTOR_OUT_OF_RANGE     },
         {"MQRC_SELECTOR_SYNTAX_ERROR"    , MQRC_SELECTOR_SYNTAX_ERROR     },
         {"MQRC_SELECTOR_TYPE_ERROR"      , MQRC_SELECTOR_TYPE_ERROR       },
         {"MQRC_SELECTOR_WRONG_TYPE"      , MQRC_SELECTOR_WRONG_TYPE       },
         {"MQRC_SERVICE_ERROR"            , MQRC_SERVICE_ERROR             },
         {"MQRC_SERVICE_NOT_AVAILABLE"    , MQRC_SERVICE_NOT_AVAILABLE     },
         {"MQRC_SIGNAL_OUTSTANDING"       , MQRC_SIGNAL_OUTSTANDING        },
         {"MQRC_SIGNAL_REQUEST_ACCEPTED"  , MQRC_SIGNAL_REQUEST_ACCEPTED   },
         {"MQRC_SIGNAL1_ERROR"            , MQRC_SIGNAL1_ERROR             },
         {"MQRC_SMPO_ERROR"               , MQRC_SMPO_ERROR                },
         {"MQRC_SOAP_AXIS_ERROR"          , MQRC_SOAP_AXIS_ERROR           },
         {"MQRC_SOAP_DOTNET_ERROR"        , MQRC_SOAP_DOTNET_ERROR         },
         {"MQRC_SOAP_URL_ERROR"           , MQRC_SOAP_URL_ERROR            },
         {"MQRC_SOURCE_BUFFER_ERROR"      , MQRC_SOURCE_BUFFER_ERROR       },
         {"MQRC_SOURCE_CCSID_ERROR"       , MQRC_SOURCE_CCSID_ERROR        },
         {"MQRC_SOURCE_DECIMAL_ENC_ERROR" , MQRC_SOURCE_DECIMAL_ENC_ERROR  },
         {"MQRC_SOURCE_FLOAT_ENC_ERROR"   , MQRC_SOURCE_FLOAT_ENC_ERROR    },
         {"MQRC_SOURCE_INTEGER_ENC_ERROR" , MQRC_SOURCE_INTEGER_ENC_ERROR  },
         {"MQRC_SOURCE_LENGTH_ERROR"      , MQRC_SOURCE_LENGTH_ERROR       },
         {"MQRC_SRC_ENV_ERROR"            , MQRC_SRC_ENV_ERROR             },
         {"MQRC_SRC_NAME_ERROR"           , MQRC_SRC_NAME_ERROR            },
         {"MQRC_SRO_ERROR"                , MQRC_SRO_ERROR                 },
         {"MQRC_SSL_ALREADY_INITIALIZED"  , MQRC_SSL_ALREADY_INITIALIZED   },
         {"MQRC_SSL_CERT_STORE_ERROR"     , MQRC_SSL_CERT_STORE_ERROR      },
         {"MQRC_SSL_CERTIFICATE_REVOKED"  , MQRC_SSL_CERTIFICATE_REVOKED   },
         {"MQRC_SSL_CONFIG_ERROR"         , MQRC_SSL_CONFIG_ERROR          },
         {"MQRC_SSL_INITIALIZATION_ERROR" , MQRC_SSL_INITIALIZATION_ERROR  },
         {"MQRC_SSL_KEY_RESET_ERROR"      , MQRC_SSL_KEY_RESET_ERROR       },
         {"MQRC_SSL_NOT_ALLOWED"          , MQRC_SSL_NOT_ALLOWED           },
         {"MQRC_SSL_PEER_NAME_ERROR"      , MQRC_SSL_PEER_NAME_ERROR       },
         {"MQRC_SSL_PEER_NAME_MISMATCH"   , MQRC_SSL_PEER_NAME_MISMATCH    },
         {"MQRC_STAT_TYPE_ERROR"          , MQRC_STAT_TYPE_ERROR           },
         {"MQRC_STOPPED_BY_CLUSTER_EXIT"  , MQRC_STOPPED_BY_CLUSTER_EXIT   },
         {"MQRC_STORAGE_CLASS_ERROR"      , MQRC_STORAGE_CLASS_ERROR       },
         {"MQRC_STORAGE_MEDIUM_FULL"      , MQRC_STORAGE_MEDIUM_FULL       },
         {"MQRC_STORAGE_NOT_AVAILABLE"    , MQRC_STORAGE_NOT_AVAILABLE     },
         {"MQRC_STRING_ERROR"             , MQRC_STRING_ERROR              },
         {"MQRC_STRING_LENGTH_ERROR"      , MQRC_STRING_LENGTH_ERROR       },
         {"MQRC_STRING_TRUNCATED"         , MQRC_STRING_TRUNCATED          },
         {"MQRC_STRUC_ID_ERROR"           , MQRC_STRUC_ID_ERROR            },
         {"MQRC_STRUC_LENGTH_ERROR"       , MQRC_STRUC_LENGTH_ERROR        },
         {"MQRC_STS_ERROR"                , MQRC_STS_ERROR                 },
         {"MQRC_SUB_ALREADY_EXISTS"       , MQRC_SUB_ALREADY_EXISTS        },
         {"MQRC_SUB_INHIBITED"            , MQRC_SUB_INHIBITED             },
         {"MQRC_SUB_NAME_ERROR"           , MQRC_SUB_NAME_ERROR            },
         {"MQRC_SUB_USER_DATA_ERROR"      , MQRC_SUB_USER_DATA_ERROR       },
         {"MQRC_SUBLEVEL_NOT_ALTERABLE"   , MQRC_SUBLEVEL_NOT_ALTERABLE    },
         {"MQRC_SUBSCRIPTION_IN_USE"      , MQRC_SUBSCRIPTION_IN_USE       },
         {"MQRC_SUPPRESSED_BY_EXIT"       , MQRC_SUPPRESSED_BY_EXIT        },
         {"MQRC_SYNCPOINT_LIMIT_REACHED"  , MQRC_SYNCPOINT_LIMIT_REACHED   },
         {"MQRC_SYNCPOINT_NOT_AVAILABLE"  , MQRC_SYNCPOINT_NOT_AVAILABLE   },
         {"MQRC_SYSTEM_BAG_NOT_ALTERABLE" , MQRC_SYSTEM_BAG_NOT_ALTERABLE  },
         {"MQRC_SYSTEM_BAG_NOT_DELETABLE" , MQRC_SYSTEM_BAG_NOT_DELETABLE  },
         {"MQRC_SYSTEM_ITEM_NOT_ALTERABLE", MQRC_SYSTEM_ITEM_NOT_ALTERABLE },
         {"MQRC_SYSTEM_ITEM_NOT_DELETABLE", MQRC_SYSTEM_ITEM_NOT_DELETABLE },
         {"MQRC_TARGET_BUFFER_ERROR"      , MQRC_TARGET_BUFFER_ERROR       },
         {"MQRC_TARGET_CCSID_ERROR"       , MQRC_TARGET_CCSID_ERROR        },
         {"MQRC_TARGET_DECIMAL_ENC_ERROR" , MQRC_TARGET_DECIMAL_ENC_ERROR  },
         {"MQRC_TARGET_FLOAT_ENC_ERROR"   , MQRC_TARGET_FLOAT_ENC_ERROR    },
         {"MQRC_TARGET_INTEGER_ENC_ERROR" , MQRC_TARGET_INTEGER_ENC_ERROR  },
         {"MQRC_TARGET_LENGTH_ERROR"      , MQRC_TARGET_LENGTH_ERROR       },
         {"MQRC_TERMINATION_FAILED"       , MQRC_TERMINATION_FAILED        },
         {"MQRC_TM_ERROR"                 , MQRC_TM_ERROR                  },
         {"MQRC_TMC_ERROR"                , MQRC_TMC_ERROR                 },
         {"MQRC_TOPIC_NOT_ALTERABLE"      , MQRC_TOPIC_NOT_ALTERABLE       },
         {"MQRC_TOPIC_STRING_ERROR"       , MQRC_TOPIC_STRING_ERROR        },
         {"MQRC_TRIGGER_CONTROL_ERROR"    , MQRC_TRIGGER_CONTROL_ERROR     },
         {"MQRC_TRIGGER_DEPTH_ERROR"      , MQRC_TRIGGER_DEPTH_ERROR       },
         {"MQRC_TRIGGER_MSG_PRIORITY_ERR" , MQRC_TRIGGER_MSG_PRIORITY_ERR  },
         {"MQRC_TRIGGER_TYPE_ERROR"       , MQRC_TRIGGER_TYPE_ERROR        },
         {"MQRC_TRUNCATED"                , MQRC_TRUNCATED                 },
         {"MQRC_TRUNCATED_MSG_ACCEPTED"   , MQRC_TRUNCATED_MSG_ACCEPTED    },
         {"MQRC_TRUNCATED_MSG_FAILED"     , MQRC_TRUNCATED_MSG_FAILED      },
         {"MQRC_UCS2_CONVERSION_ERROR"    , MQRC_UCS2_CONVERSION_ERROR     },
         {"MQRC_UNEXPECTED_ERROR"         , MQRC_UNEXPECTED_ERROR          },
         {"MQRC_UNIT_OF_WORK_NOT_STARTED" , MQRC_UNIT_OF_WORK_NOT_STARTED  },
         {"MQRC_UNKNOWN_ALIAS_BASE_Q"     , MQRC_UNKNOWN_ALIAS_BASE_Q      },
         {"MQRC_UNKNOWN_AUTH_ENTITY"      , MQRC_UNKNOWN_AUTH_ENTITY       },
         {"MQRC_UNKNOWN_CHANNEL_NAME"     , MQRC_UNKNOWN_CHANNEL_NAME      },
         {"MQRC_UNKNOWN_COMPONENT_NAME"   , MQRC_UNKNOWN_COMPONENT_NAME    },
         {"MQRC_UNKNOWN_DEF_XMIT_Q"       , MQRC_UNKNOWN_DEF_XMIT_Q        },
         {"MQRC_UNKNOWN_ENTITY"           , MQRC_UNKNOWN_ENTITY            },
         {"MQRC_UNKNOWN_OBJECT_NAME"      , MQRC_UNKNOWN_OBJECT_NAME       },
         {"MQRC_UNKNOWN_OBJECT_Q_MGR"     , MQRC_UNKNOWN_OBJECT_Q_MGR      },
         {"MQRC_UNKNOWN_Q_NAME"           , MQRC_UNKNOWN_Q_NAME            },
         {"MQRC_UNKNOWN_REF_OBJECT"       , MQRC_UNKNOWN_REF_OBJECT        },
         {"MQRC_UNKNOWN_REMOTE_Q_MGR"     , MQRC_UNKNOWN_REMOTE_Q_MGR      },
         {"MQRC_UNKNOWN_REPORT_OPTION"    , MQRC_UNKNOWN_REPORT_OPTION     },
         {"MQRC_UNKNOWN_XMIT_Q"           , MQRC_UNKNOWN_XMIT_Q            },
         {"MQRC_UNSUPPORTED_CIPHER_SUITE" , MQRC_UNSUPPORTED_CIPHER_SUITE  },
         {"MQRC_UNSUPPORTED_PROPERTY"     , MQRC_UNSUPPORTED_PROPERTY      },
         {"MQRC_UOW_CANCELED"             , MQRC_UOW_CANCELED              },
         {"MQRC_UOW_COMMITTED"            , MQRC_UOW_COMMITTED             },
         {"MQRC_UOW_ENLISTMENT_ERROR"     , MQRC_UOW_ENLISTMENT_ERROR      },
         {"MQRC_UOW_IN_PROGRESS"          , MQRC_UOW_IN_PROGRESS           },
         {"MQRC_UOW_MIX_NOT_SUPPORTED"    , MQRC_UOW_MIX_NOT_SUPPORTED     },
         {"MQRC_UOW_NOT_AVAILABLE"        , MQRC_UOW_NOT_AVAILABLE         },
         {"MQRC_USER_ID_NOT_AVAILABLE"    , MQRC_USER_ID_NOT_AVAILABLE     },
         {"MQRC_WAIT_INTERVAL_ERROR"      , MQRC_WAIT_INTERVAL_ERROR       },
         {"MQRC_WIH_ERROR"                , MQRC_WIH_ERROR                 },
         {"MQRC_WRONG_CF_LEVEL"           , MQRC_WRONG_CF_LEVEL            },
         {"MQRC_WRONG_GMO_VERSION"        , MQRC_WRONG_GMO_VERSION         },
         {"MQRC_WRONG_MD_VERSION"         , MQRC_WRONG_MD_VERSION          },
         {"MQRC_WRONG_VERSION"            , MQRC_WRONG_VERSION             },
         {"MQRC_WXP_ERROR"                , MQRC_WXP_ERROR                 },
         {"MQRC_XEPO_ERROR"               , MQRC_XEPO_ERROR                },
         {"MQRC_XMIT_Q_TYPE_ERROR"        , MQRC_XMIT_Q_TYPE_ERROR         },
         {"MQRC_XMIT_Q_USAGE_ERROR"       , MQRC_XMIT_Q_USAGE_ERROR        },
         {"MQRC_XQH_ERROR"                , MQRC_XQH_ERROR                 },
         {"MQRC_XWAIT_CANCELED"           , MQRC_XWAIT_CANCELED            },
         {"MQRC_XWAIT_ERROR"              , MQRC_XWAIT_ERROR               },
         {"MQRC_ZERO_LENGTH"              , MQRC_ZERO_LENGTH               },
         {"MQMT_SYSTEM_FIRST"             , MQMT_SYSTEM_FIRST              },
         {"MQMT_REQUEST"                  , MQMT_REQUEST                   },
         {"MQMT_REPLY"                    , MQMT_REPLY                     },
         {"MQMT_DATAGRAM"                 , MQMT_DATAGRAM                  },
         {"MQMT_REPORT"                   , MQMT_REPORT                    },
         {"MQMT_SYSTEM_LAST"              , MQMT_SYSTEM_LAST               },
         {"MQMT_APPL_FIRST"               , MQMT_APPL_FIRST                },
         {"MQMT_APPL_LAST"                , MQMT_APPL_LAST                 },
         {"MQFB_NONE"                     , MQFB_NONE                      },
         {"MQFB_SYSTEM_FIRST"             , MQFB_SYSTEM_FIRST              },
         {"MQFB_EXPIRATION"               , MQFB_EXPIRATION                },
         {"MQFB_COA"                      , MQFB_COA                       },
         {"MQFB_COD"                      , MQFB_COD                       },
         {"MQFB_QUIT"                     , MQFB_QUIT                      },
         {"MQFB_CHANNEL_COMPLETED"        , MQFB_CHANNEL_COMPLETED         },
         {"MQFB_CHANNEL_FAIL_RETRY"       , MQFB_CHANNEL_FAIL_RETRY        },
         {"MQFB_CHANNEL_FAIL"             , MQFB_CHANNEL_FAIL              },
         {"MQFB_APPL_CANNOT_BE_STARTED"   , MQFB_APPL_CANNOT_BE_STARTED    },
         {"MQFB_TM_ERROR"                 , MQFB_TM_ERROR                  },
         {"MQFB_APPL_TYPE_ERROR"          , MQFB_APPL_TYPE_ERROR           },
         {"MQFB_STOPPED_BY_MSG_EXIT"      , MQFB_STOPPED_BY_MSG_EXIT       },
         {"MQFB_XMIT_Q_MSG_ERROR"         , MQFB_XMIT_Q_MSG_ERROR          },
         {"MQFB_SYSTEM_LAST"              , MQFB_SYSTEM_LAST               },
         {"MQFB_APPL_FIRST"               , MQFB_APPL_FIRST                },
         {"MQFB_APPL_LAST"                , MQFB_APPL_LAST                 },
         {"MQFB_ACTIVITY"                 , MQFB_ACTIVITY                  },
         {"MQFB_MAX_ACTIVITIES"           , MQFB_MAX_ACTIVITIES            },
         {"MQFB_NOT_FORWARDED"            , MQFB_NOT_FORWARDED             },
         {"MQFB_NOT_DELIVERED"            , MQFB_NOT_DELIVERED             },
         {"MQFB_UNSUPPORTED_FORWARDING"   , MQFB_UNSUPPORTED_FORWARDING    },
         {"MQFB_UNSUPPORTED_DELIVERY"     , MQFB_UNSUPPORTED_DELIVERY      },
         {"MQPER_PERSISTENT"              , MQPER_PERSISTENT               },
         {"MQPER_NOT_PERSISTENT"          , MQPER_NOT_PERSISTENT           },
         {"MQPER_PERSISTENCE_AS_Q_DEF"    , MQPER_PERSISTENCE_AS_Q_DEF     },
         {"MQAT_NO_CONTEXT"               , MQAT_NO_CONTEXT                },
         {"MQAT_CICS"                     , MQAT_CICS                      },
         {"MQAT_MVS"                      , MQAT_MVS                       },
         {"MQAT_IMS"                      , MQAT_IMS                       },
         {"MQAT_OS2"                      , MQAT_OS2                       },
         {"MQAT_DOS"                      , MQAT_DOS                       },
         {"MQAT_AIX"                      , MQAT_AIX                       },
         {"MQAT_UNIX"                     , MQAT_UNIX                      },
         {"MQAT_QMGR"                     , MQAT_QMGR                      },
         {"MQAT_OS400"                    , MQAT_OS400                     },
         {"MQAT_WINDOWS"                  , MQAT_WINDOWS                   },
         {"MQAT_CICS_VSE"                 , MQAT_CICS_VSE                  },
         {"MQAT_WINDOWS_NT"               , MQAT_WINDOWS_NT                },
         {"MQAT_VMS"                      , MQAT_VMS                       },
         {"MQAT_GUARDIAN"                 , MQAT_GUARDIAN                  },
         {"MQAT_VOS"                      , MQAT_VOS                       },
         {"MQAT_SYSTEM_EXTENSION"         , MQAT_SYSTEM_EXTENSION          },
         {"MQAT_DEFAULT"                  , MQAT_DEFAULT                   },
         {"MQAT_USER_FIRST"               , MQAT_USER_FIRST                },
         {"MQAT_USER_LAST"                , MQAT_USER_LAST                 }
       };

 odq_fnc_entry( FUNCTION_ID );
 rc = odqGetMem(  l+1,
	         "Symbol",
	         (void **)&Upper );
 if (odq_Error > rc )
 {
   psource = source ;

   for( i = 0 ;
	i < l ;
	i++ )
   {
     (Upper)[i] = toupper(psource[i]);
   }
   (Upper)[l] = 0 ;


   for (i=0;i<ODQTABLE_LENGTH;i++)
   {
      if (strcmp(Upper,aodqTable[i].szString) == 0 )
      {
	 *target = aodqTable[i].mqrc;
	 fFound = 1;
      } /* endif */
   } /* endfor */
   if (!fFound)
   {
      rc = odq_InvalidInteger ;
   } /* endif */
 }
 else
 {
    rc = odq_InvalidInteger ;
 }
 odqFreeMem( "Symbol", Upper );

 odq_fnc_retcode( FUNCTION_ID, rc ) ;
 return rc ;
}

/*********************************************************************/
/*                                                                   */
/* Function: yywrap                                                  */
/*                                                                   */
/* Description: Process EOF                                          */
/*                                                                   */
/* Intended Function: Complete parsing the input at the first EOF.   */
/*                                                                   */
/* Input Parameters: none                                            */
/*                                                                   */
/* Output Parameters: none                                           */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
int yywrap(void) { return 1; }

/*********************************************************************/
/*                                                                   */
/* Function: yyerror                                                 */
/*                                                                   */
/* Description: Report lex/yacc detected errors                      */
/*                                                                   */
/* Intended Function: Identify errors in the rule table.             */
/*                                                                   */
/* Input Parameters: descriptive string                              */
/*                                                                   */
/* Output Parameters: none                                           */
/*                                                                   */
/* Returns:                                                          */
/*********************************************************************/
/*--------------------------------------------------------------------*/
/* yyerror:                                                           */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
void yyerror( char * s)
{
 char c;

/*--------------------------------------------------------------------*/
/* We have to remove comments and join up lines before checking the   */
/* grammar to handle with templates of the form:                      */
/*

format(myformat) msgtype(1234+
*comments can appear in the middle of parameters
 5678) action(ignore)

*/
/* This makes it very difficult to match up errors with the input     */
/* source, because after we've joined up the line then we're          */
/* dealing with a line which does not appear verbatim in the          */
/* input file.                                                        */
/*                                                                    */
/*--------------------------------------------------------------------*/

 odqGlobal.odqInputErrorCount ++ ;
 fprintf(stderr, "\n%s on line %d\n", s, odqLineNo ) ;
 fprintf(stderr,"%s%s", "...", yytext);

 /*--------------------------------*/
 /* read forwards for the end      */
 /* of line/file.                  */
 /*--------------------------------*/
 if ( ( 0 != yytext[0]) && ((char)EOF != yytext[0]) )
 {
 for( c=input ()
    ; ( (c!=ASCII_NEWLINE)
      &&(c!=(char)EOF)
      && (c!=0) )
    ; c=input())
 {

 }
 if (c != ASCII_NEWLINE)
 {                     /* unput \0 or EOF */
   unput(c);
 }
 fputc('\n', stderr );
 fflush(stderr);
}

 BEGIN(INITIAL);
}

#ifdef AMQ_AS400
/*********************************************************************/
/*                                                                   */
/* Function Name:  yylex_initialise                                  */
/*                                                                   */
/* Description:    Initialise the lexical analyser                   */
/*                                                                   */
/*********************************************************************/
/* Following text will be included in the Service Reference Manual . */
/* Ensure that the content is correct and up-to-date.                */
/* All updates should be made in mixed case.                         */
/*                                                                   */
/* Function:                                                         */
/* This function initialises the lexical analyser.                   */
/*                                                                   */
/* Input Parameters:  char* buf -  the command string to analyse     */
/*                                                                   */
/* Output Parameters: None                                           */
/*                                                                   */
/* Returns:                                                          */
/*                    OK - initialised correctly                     */
/* Exit Normal:       See Returns above.                             */
/*                                                                   */
/* Exit Error:        See Returns above.                             */
/*                                                                   */
/* End of text to be included in SRM                                 */
/*********************************************************************/
/*                                                                   */
/* Notes:                                                            */
/*   Restrictions:    None                                           */
/*                                                                   */
/*********************************************************************/
int yylex_initialise(void)
{
  char *filepath;

  YY_FLUSH_BUFFER;

  /*******************************************************************/
  /* to support the STRMQMDLQ command the AS400 input filename is    */
  /* passed in an environment variable.  Get the variable and remap  */
  /* stdin to the file.  The RUNMQDLQ on AS400 will still use stdin. */
  /*******************************************************************/
  filepath = getenv(AMQ_INFILE);
  if ( ((char *)0 != filepath) && ( strlen(filepath) != 0 ))
  {
    fclose(stdin);
    stdin =  fopen(filepath,"r");
    if(0!=ferror(stdin))
    {
      int errsave;
      char * errstr;
      errsave = ferror(stdin);
      errstr = strerror(errno);
      fprintf(stderr,"YYLEX_INIT error %d opening %s, stderror string: %s\n",
              errsave,filepath,errstr);
      YY_FATAL_ERROR("fread() in scanner failed");
   }
  }
  /* re-init static vars which may have old data from previous runs */
  odqLineNo = 1;
  yy_c_buf_p = (unsigned char *)0;
  yy_init = 1;
  yyin = 0;
  yyout = 0;
  yy_current_buffer = 0;
  yy_start = 0;
  return 0;
}
#endif

