#!/bin/sh

# -  Library:       WebSphere MQ
# -  Component:     WMQ SOAP Sample Programs
# -  Part:          runivt.sh
# - 
# -     <copyright 
#  notice="lm-source-program" 
#  pids="5724-H72," 
#  years="1994,2012" 
#  crc="2196156616" > 
#  Licensed Materials - Property of IBM  
#   
#  5724-H72, 
#   
#  (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.  
#   
#  US Government Users Restricted Rights - Use, duplication or  
#  disclosure restricted by GSA ADP Schedule Contract with  
#  IBM Corp.  
#  </copyright> 

echo ""
echo "---------------------------------------------------------"
echo "WebSphere MQ Transport for SOAP Install Verification Test"
echo "---------------------------------------------------------"
echo ""
echo "NB. If failures occur run SOAPCleanup.sh before"
echo "re-running the test"
echo ""

# Check WMQSOAP_HOME is set

if [ "z${WMQSOAP_HOME}" = "z" ]
then
   echo "ERROR"
   echo "Please export the WMQSOAP_HOME variable before running runivt"
   exit 1
fi

# Check we have access to java
echo "Checking and configuring the Java environment"
java -version >runivt.log 2>&1
if [ $? -ne 0 ]
then
   echo "ERROR"
   echo "The Java environment is not correctly configured, please"
   echo "ensure the JDK bin directory is included in your PATH"
   exit 1
fi

# Check we have access to the java compiler
javac -help >>runivt.log 2>&1
if [ $? -ne 0 ]
then
   echo ""
   echo "ERROR"
   echo "* The Java environment is not correctly configured, please"
   echo "* ensure the JDK bin directory is included in your PATH"
   exit 1
fi

# Set the correct CLASSPATH definitions
. ${WMQSOAP_HOME}/bin/amqwsetcp.sh >>runivt.log 2>&1
if [ $? -ne 0 ]
then
   echo ""
   echo "ERROR"
   echo "The Java environment has not been configured, an error"
   echo "occurred while setting up the CLASSPATH.  Please see runivt.log"
   echo "for details, located in the current directory"
   exit 1
fi
echo " > ------------------------------------------ Successful"
echo ""
if [ ! -d generated ]
then
   echo "Setting up the queue manager and req/resp queues"
   ${WMQSOAP_HOME}/samp/soap/setupWMQSOAP.sh >>runivt.log 2>&1
   if [ $? -ne 0 ]
   then
      echo ""
      echo "ERROR"
      echo "The configuration of MQ failed.  Please see runivt.log"
      echo "for details, located in the current directory"
      exit 1
   fi
   echo " > ------------------------------------------ Successful"
   echo ""
   echo "Deploying the Axis service"
   mkdir -p soap/server >>runivt.log 2>&1
   cp ${WMQSOAP_HOME}/samp/soap/java/server/StockQuoteAxis.java soap/server/. >>runivt.log 2>&1
   ${WMQSOAP_HOME}/bin/amqwdeployWMQService.sh -u "jms:/queue?destination=SOAPJ.demos@WMQSOAP.DEMO.QM&connectionFactory=connectQueueManager(WMQSOAP.DEMO.QM)&initialContextFactory=com.ibm.mq.jms.Nojndi" -n 10 -f soap/server/StockQuoteAxis.java >>runivt.log 2>&1
   if [ $? -ne 0 ]
   then
      echo ""
      echo "ERROR"
      echo "The Axis service failed to deploy. Please see runivt.log"
      echo "for details, located in the current directory"
      exit 1
   fi
   echo " > ------------------------------------------ Successful"
   echo ""
   echo "Compling the Axis clients"
   mkdir classes >>runivt.log 2>&1
   mkdir -p soap/clients >>runivt.log 2>&1
   cp ${WMQSOAP_HOME}/samp/soap/java/clients/*.java soap/clients/. >>runivt.log 2>&1
   # Delete any DotNet files, Java tran files
   rm -f soap/clients/SQAxis2DotNet.java soap/clients/SQAxis2AxisAsync*.java > /dev/null 2>&1
   javac -d classes soap/clients/*.java >>runivt.log 2>&1
   echo " > ------------------------------------------ Successful"
   echo ""
   echo "* + Creating client deployment descriptor"
   ${WMQSOAP_HOME}/bin/amqwclientConfig.sh >>runivt.log 2>&1
   if [ $? -ne 0 ]
   then
      echo ""
      echo "ERROR"
      echo "The Axis client config failed. Please see runivt.log"
      echo "for details, located in the current directory"
      exit 1
   fi
   cp ${WMQSOAP_HOME}/samp/soap/*.txt . >>runivt.log 2>&1
   echo " > ------------------------------------------ Successful"
   echo ""
else
   echo "Axis service already deployed"
   echo ""
fi

echo ""
echo "Running Axis samples......"

java soap.clients.RunIvt AxisWsdl AxisProxy 
