#!/bin/sh 

# -  Library:       WebSphere MQ
# -  Component:     WMQ SOAP Sample Programs
# -  Part:          setupMQ.sh
# - 
# -     <copyright 
#  notice="lm-source-program" 
#  pids="5724-H72," 
#  years="1994,2012" 
#  crc="3474140266" > 
#  Licensed Materials - Property of IBM  
#   
#  5724-H72, 
#   
#  (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.  
#   
#  US Government Users Restricted Rights - Use, duplication or  
#  disclosure restricted by GSA ADP Schedule Contract with  
#  IBM Corp.  
#  </copyright> 

QMGR=$1
if [$1 -eq ""]
then
  QMGR=WMQSOAP.DEMO.QM
fi

echo " Queue manager being used is ${QMGR}"

do_clearq()
   {
   echo "Setting up required MQ queues..."
   runmqsc ${QMGR} >>runivt.log 2>&1 << EOF

   define  ql('SYSTEM.SOAP.RESPONSE.QUEUE') BOTHRESH(3)
   define  qm('SYSTEM.SOAP.MODEL.RESPONSE.QUEUE') BOTHRESH(3) DEFTYPE(PERMDYN) DEFSOPT(SHARED) SHARE
   define  ql('SYSTEM.SOAP.SIDE.QUEUE')
   define  channel(TESTCHANNEL) CHLTYPE(SVRCONN) TRPTYPE(TCP) REPLACE
   clear  ql('SYSTEM.SOAP.RESPONSE.QUEUE')
   clear  ql('SYSTEM.SOAP.SIDE.QUEUE')
   alter qmgr CHLAUTH(DISABLED)

   end
EOF
   }

do_qmgr()
   {
   echo "Checking Queue Manager ${QMGR} is available..."
   runmqsc ${QMGR} >>runivt.log 2>&1 << EOF
   display qmgr
   end
EOF

   if [ $? -ne 0 ] 
   then
      echo "   Queue manager not available, attempting to start..."
      strmqm ${QMGR} 
      if [ $? -ne 0 ] 
      then    
         echo "   Could not start queue manager, attempting to create..."
         crtmqm ${QMGR}
         if [ $? -ne 0 ]
         then
            echo "   ERROR - could not create queue manager, aborting."
            exit -1
         else
            echo "Starting new queue manager..."
            strmqm ${QMGR}
            if [ $? -ne 0 ]
            then
               echo "   ERROR - could not start newly created queue manager, aborting."
               exit -1
            fi
         fi
      fi      
   fi
   }
 

do_runmqlsr()
   {
   echo "Checking runmqlsr..."
   if [ 0 -eq `ps -aef | grep runmqlsr | grep -v grep | wc -l` ]
   then
      echo "   runmqlsr process is not running, attempting to start..."
      ( runmqlsr -t TCP -m ${QMGR} -p 9414& 2>&1 | tee /tmp/runmqlsr.log ) > /dev/null &
      if [ $? -ne 0 ]
      then
         echo "   ERROR - could not start runmqlsr process, aborting..."
         exit -1
      fi
   fi
   }


main()
   {
   do_qmgr
   do_clearq
   do_runmqlsr
   }

main 
exit 0
