static const char sccsid[] = "@(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=samples/c/xatm/db2swit0s.c";
/******************************************************************************/
/*                                                                            */
/* Module name: db2swits.c                                                    */
/*                                                                            */
/* Description: WebSphere MQ XA Static Registration switch program for DB2    */
/*                                                                            */
/* <copyright notice="copyright-lm-source-program"                            */
/*            pids="5724-H72"                                                 */
/*            years="2011,2015"                                               */
/*            crc="4002809454" >                                              */
/*                                                                            */
/* Licensed Materials - Property of IBM                                       */
/*                                                                            */
/* 5724-H72                                                                   */
/*                                                                            */
/* (C) Copyright IBM Corp. 2011, 2015                                         */
/*                                                                            */
/* US Government Users Restricted Rights - Use, duplication or                */
/* disclosure restricted by GSA ADP Schedule Contract with                    */
/* IBM Corp.                                                                  */
/*                                                                            */
/* </copyright>                                                               */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* Includes                                                                   */
/******************************************************************************/

#include <cmqc.h>                                /* MQ header                 */
#include "xa.h"                                  /* MQ supplied XA header     */

/******************************************************************************/
/* External data declarations                                                 */
/******************************************************************************/

extern struct xa_switch_t db2xa_switch_static;

/******************************************************************************/
/*                                                                            */
/* Function name:  MQStart                                                    */
/*                                                                            */
/* Description: The queue manager calls this function to access the XA switch */
/*              of DB2                                                        */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Input Parameters:  None                                                    */
/*                                                                            */
/* Output Parameters: None                                                    */
/*                                                                            */
/* Returns:           Pointer to DB2 XA switch                                */
/*                                                                            */
/******************************************************************************/
struct xa_switch_t * MQENTRY MQStart(void)
{
   return(&db2xa_switch_static);
}

/******************************************************************************/
/* End of db2swits.c                                                          */
/******************************************************************************/
