/* @(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=samples/c/xatm/sybswit0.c */
/******************************************************************************/
/*                                                                            */
/* Module name: sybswit.c                                                     */
/*                                                                            */
/* Description: WebSphere MQ XA switch program for Sybase                     */
/*                                                                            */
/*  <copyright                                                                */
/*  notice="lm-source-program"                                                */
/*  pids="5724-H72,"                                                          */
/*  years="1998,2012"                                                         */
/*  crc="1587841497" >                                                        */
/*  Licensed Materials - Property of IBM                                      */
/*                                                                            */
/*  5724-H72,                                                                 */
/*                                                                            */
/*  (C) Copyright IBM Corp. 1998, 2012 All Rights Reserved.                   */
/*                                                                            */
/*  US Government Users Restricted Rights - Use, duplication or               */
/*  disclosure restricted by GSA ADP Schedule Contract with                   */
/*  IBM Corp.                                                                 */
/*  </copyright>                                                              */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* Includes                                                                   */
/******************************************************************************/

#include <cmqc.h>                                /* MQ header                 */
#include "xa.h"                                  /* MQ supplied XA header     */

/******************************************************************************/
/* External data declarations                                                 */
/******************************************************************************/

extern struct xa_switch_t sybase_TXS_xa_switch;

/******************************************************************************/
/*                                                                            */
/* Function name:  MQStart                                                    */
/*                                                                            */
/* Description: The queue manager calls this function to access the XA switch */
/*              of Sybase                                                     */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Input Parameters:  None                                                    */
/*                                                                            */
/* Output Parameters: None                                                    */
/*                                                                            */
/* Returns:           Pointer to Sybase XA switch                             */
/*                                                                            */
/******************************************************************************/
struct xa_switch_t * MQENTRY MQStart(void)
{
   return(&sybase_TXS_xa_switch);
}

/******************************************************************************/
/* End of sybswit.c                                                           */
/******************************************************************************/
