#
# Name: XASWIT.MAK
#
# Description: Linux makefile for DB2, Oracle, Informix and Sybase XA switch load files
#
# <copyright notice="copyright-lm-source-program"
#            pids="5724-H72"
#            years="1996,2015"
#            crc="3767423298" >
#
# Licensed Materials - Property of IBM
#
# 5724-H72
#
# (C) Copyright IBM Corp. 1996, 2015
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with
# IBM Corp.
#
# </copyright>
#
# To make the DB2 XA switch load file, run the command:-
#                make -f xaswit.mak db2swit
#
# To make the DB2 XA Static Registration switch load file, run the command:-
#                make -f xaswit.mak db2swits
#
# To make the Oracle XA switch load file, run the command:-
#                make -f xaswit.mak oraswit
#
# To make the Oracle XA Dynamic Registration switch load file, run the command:-
#                make -f xaswit.mak oraswitd
#
# To make the Informix XA switch load file, run the command:-
#                make -f xaswit.mak infswit
#
# To make the Sybase XA switch load file, run the command:-
#                make -f xaswit.mak sybswit
#
# Note: If your database libraries are in a different directory
#       to the one listed in the xxxLIBPATHxx statement, you will
#       need to alter or add that directory to the statement.

MQ_INSTALLATION_PATH=/opt/mqm
MQ_DATA_PATH=/var/mqm

CC=gcc

MQINCDIR=$(MQ_INSTALLATION_PATH)/inc
MQEXITDIR64=$(MQ_DATA_PATH)/exits64
HARDWARE:=$(shell uname -i)
MQEXITDIR32=$(MQ_DATA_PATH)/exits
# If we are on the s390x hardware platform, we need to use -m31 rather than -m32
ifeq ($(HARDWARE),s390x)
   CLFLAGS32=-shared -fPIC -m31
else
   CLFLAGS32=-shared -fPIC -m32
endif
LIBPATH32=/usr/lib
ifeq ($(HARDWARE),ppc64le)
   LIBPATH64=/usr/lib
   CLFLAGS64=-shared -fPIC -m64 -Wl,--no-as-needed
else
   LIBPATH64=/usr/lib64
   CLFLAGS64=-shared -fPIC -m64
endif
#-------------------------------------------------------------------------------
# DB2 XA switch load file
#-------------------------------------------------------------------------------
DB2LIBS=-ldb2

# Uncomment only one pair of DB2LIBPATH32/DB2LIBPATH64 statements

# The following lines are for DB2 V8.1
# DB2LIBPATH32=/opt/IBM/db2/V8.1/lib
# DB2LIBPATH64=/opt/IBM/db2/V8.1/lib64

# The following lines are for DB2 V9.1
# DB2LIBPATH32=/opt/IBM/db2/V9.1/lib32
# DB2LIBPATH64=/opt/IBM/db2/V9.1/lib64

# The following lines are for DB2 V9.5
DB2LIBPATH32=/opt/IBM/db2/V9.5/lib32
DB2LIBPATH64=/opt/IBM/db2/V9.5/lib64

# The following lines are for DB2 V9.7
# DB2LIBPATH32=/opt/IBM/db2/V9.7/lib32
# DB2LIBPATH64=/opt/IBM/db2/V9.7/lib64

DB2LIBFLAGS32=-L $(DB2LIBPATH32) -Wl,-rpath=$(DB2LIBPATH32) -Wl,-rpath=$(LIBPATH32) $(DB2LIBS)
DB2LIBFLAGS64=-L $(DB2LIBPATH64) -Wl,-rpath=$(DB2LIBPATH64) -Wl,-rpath=$(LIBPATH64) $(DB2LIBS)

db2swit:
	$(CC) $(CLFLAGS32) -I $(MQINCDIR) $(DB2LIBFLAGS32) -o $(MQEXITDIR32)/db2swit db2swit.c
	$(CC) $(CLFLAGS64) -I $(MQINCDIR) $(DB2LIBFLAGS64) -o $(MQEXITDIR64)/db2swit db2swit.c

#-------------------------------------------------------------------------------
# DB2 XA Static Registration switch load files
#-------------------------------------------------------------------------------

db2swits:
	$(CC) $(CLFLAGS32) -I $(MQINCDIR) $(DB2LIBFLAGS32) -o $(MQEXITDIR32)/db2swits db2swits.c
	$(CC) $(CLFLAGS64) -I $(MQINCDIR) $(DB2LIBFLAGS64) -o $(MQEXITDIR64)/db2swits db2swits.c

#-------------------------------------------------------------------------------
# Oracle XA switch load file
#-------------------------------------------------------------------------------
ORALIBS=-lclntsh -lm

# The following lines are for Oracle 9,10 and 11
ORALIBPATH32=$(ORACLE_HOME)/lib32
ORALIBPATH64=$(ORACLE_HOME)/lib

ORALIBFLAGS32=-L $(ORALIBPATH32) -Wl,-rpath=$(ORALIBPATH32) -Wl,-rpath=$(LIBPATH32) $(ORALIBS)
ORALIBFLAGS64=-L $(ORALIBPATH64) -Wl,-rpath=$(ORALIBPATH64) -Wl,-rpath=$(LIBPATH64) $(ORALIBS)

oraswit:
	$(CC) $(CLFLAGS32) -I $(MQINCDIR) $(ORALIBFLAGS32) -o $(MQEXITDIR32)/oraswit oraswit.c
	$(CC) $(CLFLAGS64) -I $(MQINCDIR) $(ORALIBFLAGS64) -o $(MQEXITDIR64)/oraswit oraswit.c

#-------------------------------------------------------------------------------
# Oracle XA Dynamic Registration switch load files
#-------------------------------------------------------------------------------

oraswitd:
	$(CC) $(CLFLAGS32) -I $(MQINCDIR) $(ORALIBFLAGS32) -o $(MQEXITDIR32)/oraswitd oraswitd.c
	$(CC) $(CLFLAGS64) -I $(MQINCDIR) $(ORALIBFLAGS64) -o $(MQEXITDIR64)/oraswitd oraswitd.c

#-------------------------------------------------------------------------------
# Informix XA switch load files
#
# Note: If you have have no requirement for 32-bit Informix applications,
#       you can remove the statement building the 32-bit switch load file.
#-------------------------------------------------------------------------------
INFDIR32=/opt/informix/32-bit
INFDIR64=/opt/informix/64-bit

# Note using a command to pick up the correct threaded libraries, so will need
# to set INFORMIXDIR for 32-bit and 64-bit generation of switch load file.
# Note ensure the qm.ini file XAResourceManager stanza attribute ThreadOfControl
# is set to 'THREAD' when using these Informix libraries
THREADOFCONTROL=THREAD
INFLIBS32=-lthxa `INFORMIXDIR=$(INFDIR32) THREADLIB=POSIX $(INFDIR32)/bin/esql -thread -libs`
INFLIBS64=-lthxa `INFORMIXDIR=$(INFDIR64) THREADLIB=POSIX $(INFDIR64)/bin/esql -thread -libs`

# Note using a command to pick up the correct non-threaded libraries, so will
# need to set INFORMIXDIR for 32-bit and 64-bit generation of switch load file.
# Note ensure the qm.ini file XAResourceManager stanza attribute ThreadOfControl
# is set to 'PROCESS' when using these Informix libraries
# THREADOFCONTROL=PROCESS
# INFLIBS32=-lifxa `INFORMIXDIR=$(INFDIR32) $(INFDIR32)/bin/esql -libs`
# INFLIBS64=-lifxa `INFORMIXDIR=$(INFDIR64) $(INFDIR64)/bin/esql -libs`

# The following lines are for Informix IDS 9.40, 10.0, 11.10 and 11.50 with Client SDK 2.90, 3.00 and 3.50
INFLIBPATH32=$(INFDIR32)/lib
INFLIBPATH64=$(INFDIR64)/lib

INFLIBFLAGS32=-L $(INFLIBPATH32)/esql -L $(INFLIBPATH32) -Wl,-rpath=$(INFLIBPATH32)/esql -Wl,-rpath=$(INFLIBPATH32) -Wl,-rpath=$(LIBPATH32) $(INFLIBS32)
INFLIBFLAGS64=-L $(INFLIBPATH64)/esql -L $(INFLIBPATH64) -Wl,-rpath=$(INFLIBPATH64)/esql -Wl,-rpath=$(INFLIBPATH64) -Wl,-rpath=$(LIBPATH64) $(INFLIBS64)

infswit:
	$(CC) $(CLFLAGS32) -I $(MQINCDIR) $(INFLIBFLAGS32) -o $(MQEXITDIR32)/infswit infswit.c
	$(CC) $(CLFLAGS64) -I $(MQINCDIR) $(INFLIBFLAGS64) -o $(MQEXITDIR64)/infswit infswit.c
	@echo ">>>----< Ensure the qm.ini file XAResourceManager stanza attribute ThreadOfControl\
	is set to '$(THREADOFCONTROL)' when using these Informix switch load files >----<<<"

#-------------------------------------------------------------------------------
# Sybase XA switch load files
# Note: linking to the shared libraries rather than the archive libraries
#-------------------------------------------------------------------------------

# The following lines are for Sybase 12.5
# SYBLIBS32=-lxadtm -lct_r -lcs_r -ltcl_r -lcomn_r -lintl_r -lm
# SYBLIBS64=-lxadtm64 -lct_r64 -lcs_r64 -ltcl_r64 -lcomn_r64 -lintl_r64 -lm

# The following lines are for Sybase 15
SYBLIBS32=-lsybxadtm -lsybct_r -lsybcs_r -lsybtcl_r -lsybcomn_r -lsybintl_r -lsybunic -lm
SYBLIBS64=-lsybxadtm64 -lsybct_r64 -lsybcs_r64 -lsybtcl_r64 -lsybcomn_r64 -lsybintl_r64 -lsybunic64 -lm

SYBLIBPATH32=$(SYBASE)/$(SYBASE_OCS)/lib
SYBLIBPATH64=$(SYBASE)/$(SYBASE_OCS)/lib

SYBLIBFLAGS32=-L $(SYBLIBPATH32) -Wl,-rpath=$(SYBLIBPATH32) -Wl,-rpath=$(LIBPATH32) $(SYBLIBS32)
SYBLIBFLAGS64=-L $(SYBLIBPATH64) -Wl,-rpath=$(SYBLIBPATH64) -Wl,-rpath=$(LIBPATH64) $(SYBLIBS64)

sybswit:
	$(CC) $(CLFLAGS32) -I $(MQINCDIR) $(SYBLIBFLAGS32) -o $(MQEXITDIR32)/sybswit sybswit.c
	$(CC) $(CLFLAGS64) -I $(MQINCDIR) $(SYBLIBFLAGS64) -o $(MQEXITDIR64)/sybswit sybswit.c

