/* @(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=include/imqbin.pre_hpp */
#ifndef _IMQBIN_HPP_
#define _IMQBIN_HPP_

//  Library:       WebSphere MQ
//  Component:     IMQB (WebSphere MQ C++ Support)
//  Part:          IMQBIN.HPP
//
//  Description:   "ImqBinary" class declaration
//  <copyright 
//  notice="lm-source-program" 
//  pids="" 
//  years="1994,2005" 
//  crc="1519572636" > 
//  Licensed Materials - Property of IBM  
//   
//   
//   
//  (C) Copyright IBM Corp. 1994, 2005 All Rights Reserved.  
//   
//  US Government Users Restricted Rights - Use, duplication or  
//  disclosure restricted by GSA ADP Schedule Contract with  
//  IBM Corp.  
//  </copyright> 

#include <imqitm.hpp> // ImqItem


#define ImqBinary ImqBin

class IMQ_EXPORTCLASS ImqBinary : public ImqItem {
  void * opvoid ;
  size_t ouiLength ;
protected :
  // New methods:
  void clear ( );
public :
  // Overloaded "ImqItem" methods:
  virtual ImqBoolean copyOut ( ImqMsg & );
  virtual ImqBoolean pasteIn ( ImqMsg & );
  // New methods:
  ImqBinary ( );
  ImqBinary ( const ImqBinary & );
  ImqBinary ( const void *, const size_t );
  virtual ~ ImqBinary ( );
  void operator = ( const ImqBinary & );
  ImqBoolean operator == ( const ImqBinary & ) const ;
  ImqBoolean copyOut ( void *, const size_t, const char = 0 );
  size_t dataLength ( ) const { return ouiLength ; }
  ImqBoolean isNull ( ) const ;
  ImqBoolean setDataLength ( const size_t );
  void * dataPointer ( ) const { return opvoid ; }
  ImqBoolean set ( const void *, const size_t );
} ;


#endif
