#
# Name:          AMQODQX.MK
#
# Description:   Makefile for the DLQ handler sample
#
#   <copyright 
#   notice="lm-source-program" 
#   pids="5724-H72," 
#   years="1994,2012" 
#   crc="1727370135" > 
#   Licensed Materials - Property of IBM  
#    
#   5724-H72, 
#    
#   (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.  
#    
#   US Government Users Restricted Rights - Use, duplication or  
#   disclosure restricted by GSA ADP Schedule Contract with  
#   IBM Corp.  
#   </copyright> 
#
# The rule table parsing of the DLQ handler sample uses the
# LEX and YACC tools. Because not all customers will have access
# to these tools both the LEX and YACC source (amqodqpa.l, amqodqma.y)
# and the generated c source (amqodqpa.c, amqodqma.c amqodqma.h) are
# shipped.
# This makefile assumes that LEX and YACC are NOT available and builds
# directly from the shipped c source. Sample statements for generating
# from the LEX/YACC source are commented out on lines prefixed by
# '#LEXYACC# '.
#
#LEXYACC# LEX=lex
#LEXYACC# YACC=yacc
# The MQ installation path
MQ_INSTALLATION_PATH=/opt/mqm
# The name of the library supporting the WebSphere MQ verbs
MQML=$(MQ_INSTALLATION_PATH)/lib
# The name of the directory including the cmqc.h header
MQMI=$(MQ_INSTALLATION_PATH)/inc
# The name of the compiler to use
cc=cc
#The default compiler flags to use
CFLAGS=-I. -I$(MQMI)

# The libraries to include
LDLIBS=-lmqm_r -lmqmcs_r -lmqmzse -mt -lsocket -lc -lnsl -ldl -L$(MQML)

# The rule for converting .c objects to .o objects
.c.o:
	${cc} $(CFLAGS) -c -o $@ $<

# The first object in the makefile is the default
# object to build.
# All of the objects in this makefile are components of
# amqsdlq.
all: amqsdlq

# The mainline routine
amqodqka.o: \
amqodqka.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

# The queue browser
amqodqla.o: \
amqodqla.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

#LEXYACC# amqodqma.c: amqodqma.y
#LEXYACC# 	$(YACC) -d amqodqma.y ;\
#LEXYACC# 	mv y.tab.c amqodqma.c ;\
#LEXYACC# 	mv y.tab.h amqodqma.h

# The rule table parser
amqodqma.o: \
amqodqma.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

# The pattern matching code
amqodqna.o: \
amqodqna.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

# The message history management
amqodqoa.o: \
amqodqoa.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

#LEXYACC# amqodqpa.c: amqodqpa.l
#LEXYACC# 	$(LEX) amqodqpa.l ;\
#LEXYACC# 	mv lex.yy.c amqodqpa.c

# The rule table lexer
amqodqpa.o: amqodqpa.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

# Common services (message, trace, etc )
amqodqua.o: \
amqodqua.c \
amqodqha.h \
amqodkha.h \
amqodtha.h

# Build the objects into an executable program
amqsdlq: amqodqka.o amqodqla.o amqodqma.o amqodqna.o amqodqoa.o amqodqpa.o amqodqua.o
	$(CC) -o amqsdlq amqodqka.o amqodqla.o amqodqma.o amqodqna.o amqodqoa.o amqodqpa.o amqodqua.o $(LDLIBS)
