#!/bin/sh

# -  Library:       WebSphere MQ
# -  Component:     WMQ SOAP Sample Programs
# -  Part:          amqwsetcp.sh
# - 
# -     <copyright 
#  notice="lm-source-program" 
#  pids="5724-H72," 
#  years="1994,2012" 
#  crc="3231024976" > 
#  Licensed Materials - Property of IBM  
#   
#  5724-H72, 
#   
#  (C) Copyright IBM Corp. 1994, 2012 All Rights Reserved.  
#   
#  US Government Users Restricted Rights - Use, duplication or  
#  disclosure restricted by GSA ADP Schedule Contract with  
#  IBM Corp.  
#  </copyright> 

status=0

# Check WMQSOAP_HOME is set
if [ "z${WMQSOAP_HOME}" = "z" ] 
then
      echo "ERROR - please export WMQSOAP_HOME"
      status=1
fi

if [ $status -eq 0 ]
then
   # Source any local configuration settings
   if [ -r ${WMQSOAP_HOME}/samp/soap/local_settings ]
   then
      . ${WMQSOAP_HOME}/samp/soap/local_settings
   fi

   if [ "z${1}" != "znocheckenvironment" ]
   then
      if [ ! -f ${WMQSOAP_HOME}/java/lib/soap/axis.jar ] 
      then
         echo "ERROR - axis.jar not found."
         echo "Please copy the required Axis jar files from the WebSphere MQ installation CD."
         echo "If the files are copied to other than \"${WMQSOAP_HOME}/java/lib/soap\","
         echo "edit 'amqwsetcp.sh' so that it looks for axis.jar in the right place and also"
         echo "sets up the CLASSPATH correctly".
         status=1
      fi
   
      if [ $status -eq 0 ] && [ ! -f ${WMQSOAP_HOME}/java/lib/com.ibm.mq.soap.jar ]
      then
         echo "ERROR - com.ibm.mq.soap.jar not found."
         echo "Recheck configuration and if really necessary, edit amqwsetcp.sh"
         status=1
      fi
   fi
   
   if [ $status -eq 0 ]
   then
      # Ensure the SOAP samples directory is in the PATH if it isn't already
      if [ `echo ${PATH} | grep -c ${WMQSOAP_HOME}/samp/soap` -eq 0 ]
      then
         PATH=${WMQSOAP_HOME}/samp/soap:${PATH}
         export PATH
      fi
    
      # Ensure the bin directory is in the PATH if it isn't already
      if [ `echo ${PATH} | grep -c ${WMQSOAP_HOME}/bin` -eq 0 ]
      then
         PATH=${WMQSOAP_HOME}/bin:${PATH}
         export PATH
      fi
    
      # for user functions
      # put these first so any user changes (eg redeploy of demo) win over 
      classpath=classes:generated/client/remote:generated/server
      
      # - SOAP classes and demos
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.soapasync_MA0V.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.soap.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.commonservices.jar
      
      # - for Axis
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/axis.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/jaxrpc.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/saaj.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/commons-logging-1.0.4.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/commons-discovery-0.2.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/wsdl4j-1.5.1.jar

      # - for xml/xerces
      if [ "z${MQXML4J}" = "z" ] 
          then
              classpath=${classpath}:/opt/IBMJava2-142/jre/lib/xml.jar
          else
              classpath=${classpath}:${MQXML4J}/xml.jar
      fi

      # - for Axis with JDK 1.4
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/soap/servlet.jar
      
      # - for MQ/JMS
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.headers.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.pcf.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.jmqi.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.jmqi.remote.jar      
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/com.ibm.mq.jmqi.local.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/connector.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/jta.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/jndi.jar
      classpath=${classpath}:${WMQSOAP_HOME}/java/lib/ldap.jar
      
      CLASSPATH=${classpath}
      export CLASSPATH
   fi
fi
