"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const debug_1 = require("debug");
const debug = debug_1.default('axm:eventloopaction');
const module_1 = require("../utils/module");
class Inspector {
    constructor(actionFeature) {
        this.MODULE_NAME = 'event-loop-inspector';
        this.actionFeature = actionFeature;
    }
    init() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => {
                module_1.default.detectModule(this.MODULE_NAME, (err, inspectorPath) => {
                    if (err) {
                        debug(err);
                        return reject(err);
                    }
                    const res = this.exposeActions(inspectorPath);
                    if (res instanceof Error) {
                        return reject(res);
                    }
                    return resolve();
                });
            }).catch((e) => console.error(e));
        });
    }
    exposeActions(inspectorPath) {
        let inspector = module_1.default.loadModule(inspectorPath, this.MODULE_NAME, [true]);
        if (inspector instanceof Error || !inspector) {
            return inspector;
        }
        /**
         * Heap snapshot
         */
        return this.actionFeature.action('km:event-loop-dump', function (reply) {
            const dump = inspector.dump();
            return reply({
                success: true,
                dump: dump
            });
        });
    }
}
exports.default = Inspector;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRMb29wSW5zcGVjdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2FjdGlvbnMvZXZlbnRMb29wSW5zcGVjdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGlDQUF5QjtBQUN6QixNQUFNLEtBQUssR0FBRyxlQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQTtBQUUxQyw0Q0FBbUM7QUFJbkM7SUFLRSxZQUFhLGFBQTZCO1FBSGxDLGdCQUFXLEdBQUcsc0JBQXNCLENBQUE7UUFJMUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUE7SUFDcEMsQ0FBQztJQUVLLElBQUk7O1lBQ1IsT0FBTyxJQUFJLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxNQUFNLEVBQUUsRUFBRTtnQkFDckMsZ0JBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLEdBQUcsRUFBRSxhQUFhLEVBQUUsRUFBRTtvQkFFMUQsSUFBSSxHQUFHLEVBQUU7d0JBQ1AsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFBO3dCQUNWLE9BQU8sTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFBO3FCQUNuQjtvQkFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsQ0FBQyxDQUFBO29CQUU3QyxJQUFJLEdBQUcsWUFBWSxLQUFLLEVBQUU7d0JBQ3hCLE9BQU8sTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFBO3FCQUNuQjtvQkFDRCxPQUFPLE9BQU8sRUFBRSxDQUFBO2dCQUNsQixDQUFDLENBQUMsQ0FBQTtZQUNKLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFBO1FBQ25DLENBQUM7S0FBQTtJQUVPLGFBQWEsQ0FBRSxhQUFhO1FBQ2xDLElBQUksU0FBUyxHQUFHLGdCQUFLLENBQUMsVUFBVSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTtRQUV6RSxJQUFJLFNBQVMsWUFBWSxLQUFLLElBQUksQ0FBQyxTQUFTLEVBQUU7WUFDNUMsT0FBTyxTQUFTLENBQUE7U0FDakI7UUFFRDs7V0FFRztRQUNILE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsb0JBQW9CLEVBQUUsVUFBVSxLQUFLO1lBQ3BFLE1BQU0sSUFBSSxHQUFHLFNBQVMsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtZQUU3QixPQUFPLEtBQUssQ0FBQztnQkFDWCxPQUFPLEVBQUUsSUFBSTtnQkFDYixJQUFJLEVBQUUsSUFBSTthQUNYLENBQUMsQ0FBQTtRQUNKLENBQUMsQ0FBQyxDQUFBO0lBQ0osQ0FBQztDQUNGO0FBL0NELDRCQStDQyJ9