"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const serviceManager_1 = require("../serviceManager");
const actions_1 = require("../services/actions");
class ActionsFeature {
    constructor(autoExit) {
        this.listenerInitiated = false;
        serviceManager_1.ServiceManager.set('actionsService', new actions_1.default(this));
        this.actionsService = serviceManager_1.ServiceManager.get('actionsService');
        if (autoExit) {
            // clean listener if event loop is empty
            // important to ensure apm will not prevent application to stop
            this.timer = setInterval(() => {
                const dump = serviceManager_1.ServiceManager.get('eventLoopService').inspector.dump();
                if (!dump || (dump.setImmediates.length === 0 &&
                    dump.nextTicks.length === 0 &&
                    (Object.keys(dump.handles).length === 0 || (Object.keys(dump.handles).length === 1 &&
                        dump.handles.hasOwnProperty('Socket') &&
                        dump.handles.Socket.length === 2 &&
                        (dump.handles.Socket[0].fd === 1 ||
                            dump.handles.Socket[0].fd === -1) &&
                        (dump.handles.Socket[1].fd === 2 ||
                            dump.handles.Socket[1].fd === -1))) &&
                    Object.keys(dump.requests).length === 0)) {
                    process.removeListener('message', this.listener);
                }
            }, 1000);
            this.timer.unref();
        }
    }
    listener(data) {
        if (!data)
            return false;
        const actionName = data.msg ? data.msg : data.action_name ? data.action_name : data;
        let actionData = serviceManager_1.ServiceManager.get('actions').get(actionName);
        let fn = actionData ? actionData.fn : null;
        const reply = actionData ? actionData.reply : null;
        if (actionData) {
            // In case 2 arguments has been set but no options has been transmitted
            if (fn.length === 2) {
                let params = {};
                if (typeof data === 'object') {
                    params = data.opts;
                }
                return fn(params, reply);
            }
            return fn(reply);
        }
        // -----------------------------------------------------------
        //                      Scoped actions
        // -----------------------------------------------------------
        if (data.uuid === undefined || data.action_name === undefined) {
            return false;
        }
        actionData = serviceManager_1.ServiceManager.get('actionsScoped').get(actionName);
        if (data.action_name === actionName) {
            const res = {
                send: (dt) => {
                    serviceManager_1.ServiceManager.get('transport').send('axm:scoped_action:stream', {
                        data: dt,
                        uuid: data.uuid,
                        action_name: actionName
                    });
                },
                error: (dt) => {
                    serviceManager_1.ServiceManager.get('transport').send('axm:scoped_action:error', {
                        data: dt,
                        uuid: data.uuid,
                        action_name: actionName
                    });
                },
                end: (dt) => {
                    serviceManager_1.ServiceManager.get('transport').send('axm:scoped_action:end', {
                        data: dt,
                        uuid: data.uuid,
                        action_name: actionName
                    });
                }
            };
            actionData.fn(data.opts || null, res);
        }
    }
    initListener() {
        if (this.listenerInitiated)
            return;
        if (serviceManager_1.ServiceManager.get('transport').transport) {
            serviceManager_1.ServiceManager.get('transport').transport.on('trigger:*', this.listener);
        }
        else {
            process.on('message', this.listener);
        }
        this.listenerInitiated = true;
    }
    init(conf, force) {
        this.actionsService.init(conf, force);
        return {
            action: this.action
        };
    }
    destroy() {
        this.actionsService.destroy();
        serviceManager_1.ServiceManager.reset('actions');
        serviceManager_1.ServiceManager.reset('actionsScoped');
        process.removeListener('message', this.listener);
        clearInterval(this.timer);
    }
    action(actionName, opts, fn) {
        if (!fn) {
            fn = opts;
            opts = null;
        }
        const check = this.check(actionName, fn);
        if (!check) {
            return check;
        }
        let type = 'custom';
        if (actionName.indexOf('km:') === 0 || actionName.indexOf('internal:') === 0) {
            type = 'internal';
        }
        if (serviceManager_1.ServiceManager.get('transport')) {
            serviceManager_1.ServiceManager.get('transport').addAction({
                action_name: actionName, action_type: type, opts, arity: fn.length
            });
        }
        const reply = (data) => {
            serviceManager_1.ServiceManager.get('transport').send('axm:reply', {
                at: new Date().getTime(),
                action_name: actionName,
                return: data
            });
        };
        serviceManager_1.ServiceManager.get('actions').set(actionName, { fn, reply });
    }
    scopedAction(actionName, fn) {
        const check = this.check(actionName, fn);
        if (!check) {
            return check;
        }
        // Notify the action
        if (serviceManager_1.ServiceManager.get('transport')) {
            serviceManager_1.ServiceManager.get('transport').addAction({
                action_name: actionName, action_type: 'scoped'
            });
        }
        serviceManager_1.ServiceManager.get('actionsScoped').set(actionName, { fn: fn });
    }
    check(actionName, fn) {
        if (!actionName) {
            console.error('[PMX] action.action_name is missing');
            return false;
        }
        if (!fn) {
            console.error('[PMX] callback is missing');
            return false;
        }
        return true;
    }
}
exports.default = ActionsFeature;
//# sourceMappingURL=data:application/json;base64,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